/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.vm;

import java.beans.EventSetDescriptor;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jem.internal.beaninfo.vm.FeatureDescriptorEquality;
import org.eclipse.jem.internal.beaninfo.vm.MethodDescriptorEquality;

public class EventSetDescriptorEquality
extends FeatureDescriptorEquality {
    private ArrayList fListenerMethodDescriptors;

    static void INIT() {
        try {
            MAP_EQUALITY.put(EventSetDescriptor.class, EventSetDescriptorEquality.class.getConstructor(EventSetDescriptor.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }

    public EventSetDescriptorEquality() {
    }

    public EventSetDescriptorEquality(EventSetDescriptor descr) {
        super(descr);
    }

    @Override
    protected void clearFeature() {
        super.clearFeature();
        this.fListenerMethodDescriptors = null;
    }

    protected ArrayList listenerMethodDescriptors() {
        if (this.fListenerMethodDescriptors == null) {
            MethodDescriptor[] mds = ((EventSetDescriptor)this.fFeature).getListenerMethodDescriptors();
            this.fListenerMethodDescriptors = new ArrayList(mds.length);
            int i = 0;
            while (i < mds.length) {
                this.fListenerMethodDescriptors.add(new MethodDescriptorEquality(mds[i]));
                ++i;
            }
        }
        return this.fListenerMethodDescriptors;
    }

    @Override
    protected int calculateHashCode() {
        int hashcode = super.calculateHashCode();
        EventSetDescriptor bd = (EventSetDescriptor)this.fFeature;
        int hc = bd.getAddListenerMethod().hashCode();
        Method[] methods = bd.getListenerMethods();
        int mhc = 0;
        int i = 0;
        while (i < methods.length) {
            mhc = mhc * 31 + methods[i].hashCode();
            ++i;
        }
        hc += mhc;
        hc += this.listenerMethodDescriptors().hashCode();
        hc += bd.getListenerType().hashCode();
        hc += bd.getRemoveListenerMethod().hashCode();
        hc += (bd.isInDefaultEventSet() ? Boolean.TRUE : Boolean.FALSE).hashCode();
        return hashcode * 31 + (hc += (bd.isUnicast() ? Boolean.TRUE : Boolean.FALSE).hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this.identityTest(obj)) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        EventSetDescriptor oe = (EventSetDescriptor)((FeatureDescriptorEquality)obj).fFeature;
        EventSetDescriptor fe = (EventSetDescriptor)this.fFeature;
        EventSetDescriptorEquality oee = (EventSetDescriptorEquality)obj;
        if (!oe.getAddListenerMethod().equals(fe.getAddListenerMethod())) {
            return false;
        }
        if (!Arrays.equals(oe.getListenerMethods(), fe.getListenerMethods())) {
            return false;
        }
        if (oe.getListenerType() != fe.getListenerType()) {
            return false;
        }
        if (oe.getRemoveListenerMethod() != fe.getRemoveListenerMethod()) {
            return false;
        }
        if (oe.isInDefaultEventSet() != fe.isInDefaultEventSet()) {
            return false;
        }
        if (oe.isUnicast() != oe.isUnicast()) {
            return false;
        }
        if (this.fListenerMethodDescriptors != null || oee.fListenerMethodDescriptors != null) {
            if (!oee.listenerMethodDescriptors().equals(this.listenerMethodDescriptors())) {
                return false;
            }
        } else {
            MethodDescriptor[] theirs;
            MethodDescriptor[] ours = fe.getListenerMethodDescriptors();
            if (ours.length != (theirs = oe.getListenerMethodDescriptors()).length) {
                return false;
            }
            if (ours.length > 0) {
                MethodDescriptorEquality workingOurs = new MethodDescriptorEquality();
                MethodDescriptorEquality workingThiers = new MethodDescriptorEquality();
                int i = 0;
                while (i < ours.length) {
                    workingOurs.setFeature(ours[i]);
                    workingThiers.setFeature(theirs[i]);
                    if (!workingOurs.equals(workingThiers)) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }
}

