/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.assertion.PublisherAssertion;
import org.uddi4j.request.AddPublisherAssertions;
import org.uddi4j.request.DeleteBinding;
import org.uddi4j.request.DeleteBusiness;
import org.uddi4j.request.DeletePublisherAssertions;
import org.uddi4j.request.DeleteService;
import org.uddi4j.request.DeleteTModel;
import org.uddi4j.request.DiscardAuthToken;
import org.uddi4j.request.FindBinding;
import org.uddi4j.request.FindBusiness;
import org.uddi4j.request.FindRelatedBusinesses;
import org.uddi4j.request.FindService;
import org.uddi4j.request.FindTModel;
import org.uddi4j.request.GetAssertionStatusReport;
import org.uddi4j.request.GetAuthToken;
import org.uddi4j.request.GetBindingDetail;
import org.uddi4j.request.GetBusinessDetail;
import org.uddi4j.request.GetBusinessDetailExt;
import org.uddi4j.request.GetPublisherAssertions;
import org.uddi4j.request.GetRegisteredInfo;
import org.uddi4j.request.GetServiceDetail;
import org.uddi4j.request.GetTModelDetail;
import org.uddi4j.request.SaveBinding;
import org.uddi4j.request.SaveBusiness;
import org.uddi4j.request.SaveService;
import org.uddi4j.request.SaveTModel;
import org.uddi4j.request.SetPublisherAssertions;
import org.uddi4j.request.ValidateValues;
import org.uddi4j.response.AssertionStatusReport;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BindingDetail;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.BusinessDetailExt;
import org.uddi4j.response.BusinessList;
import org.uddi4j.response.CompletionStatus;
import org.uddi4j.response.DispositionReport;
import org.uddi4j.response.PublisherAssertions;
import org.uddi4j.response.RegisteredInfo;
import org.uddi4j.response.RelatedBusinessesList;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.response.ServiceList;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportException;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.AuthInfo;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.DiscoveryURLs;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;
import org.uddi4j.util.TModelBag;
import org.uddi4j.util.UploadRegister;
import org.w3c.dom.Element;

public class UDDIProxy {
    protected URL inquiryURL = null;
    protected URL publishURL = null;
    TransportFactory transportFactory = null;
    Properties config = null;
    private Properties cachedUddi4jPropertiesFile;
    public static final String INQUIRY_URL_PROPERTY = "org.uddi4j.inquiryURL";
    public static final String PUBLISH_URL_PROPERTY = "org.uddi4j.publishURL";
    public static final String LOGGING_PROPERTY = "org.uddi4j.logEnabled";
    public static final String HTTP_BASIC_AUTH_USERNAME_PROPERTY = "http.basicAuthUserName";
    public static final String HTTP_BASIC_AUTH_PASSWORD_PROPERTY = "http.basicAuthPassword";
    public static final String HTTP_PROXY_HOST_PROPERTY = "http.proxyHost";
    public static final String HTTP_PROXY_PORT_PROPERTY = "http.proxyPort";
    public static final String HTTP_PROXY_USERNAME_PROPERTY = "http.proxyUserName";
    public static final String HTTP_PROXY_PASSWORD_PROPERTY = "http.proxyPassword";
    public static final String TRANSPORT_CLASSNAME_PROPERTY = "org.uddi4j.TransportClassName";
    private static final String[] propertyNames = new String[]{"org.uddi4j.inquiryURL", "org.uddi4j.publishURL", "org.uddi4j.logEnabled", "http.basicAuthUserName", "http.basicAuthPassword", "http.proxyHost", "http.proxyPort", "http.proxyUserName", "http.proxyPassword", "org.uddi4j.TransportClassName"};

    public UDDIProxy() {
        try {
            this.setConfiguration(new Properties());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public UDDIProxy(URL inquiryURL, URL publishURL) {
        Properties props = new Properties();
        if (inquiryURL != null) {
            props.setProperty(INQUIRY_URL_PROPERTY, inquiryURL.toString());
        }
        if (publishURL != null) {
            props.setProperty(PUBLISH_URL_PROPERTY, publishURL.toString());
        }
        try {
            this.setConfiguration(props);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public UDDIProxy(Properties p) throws MalformedURLException {
        this.setConfiguration(p);
    }

    public void setConfiguration(Properties props) throws MalformedURLException {
        this.config = new Properties();
        this.config.setProperty(TRANSPORT_CLASSNAME_PROPERTY, "org.uddi4j.transport.ApacheSOAPTransport");
        Exception exception = null;
        try {
            if (this.cachedUddi4jPropertiesFile == null) {
                this.cachedUddi4jPropertiesFile = new Properties();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("uddi4j.properties");
                if (inputStream != null) {
                    this.cachedUddi4jPropertiesFile.load(inputStream);
                }
            }
            this.overrideProperties(this.config, this.cachedUddi4jPropertiesFile);
        }
        catch (IOException e) {
            exception = e;
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        this.overrideProperties(this.config, System.getProperties());
        this.overrideProperties(this.config, props);
        if (this.config.getProperty(INQUIRY_URL_PROPERTY) != null) {
            this.setInquiryURL(this.config.getProperty(INQUIRY_URL_PROPERTY));
        } else if (this.inquiryURL != null) {
            this.config.setProperty(INQUIRY_URL_PROPERTY, this.inquiryURL.toString());
        }
        if (this.config.getProperty(PUBLISH_URL_PROPERTY) != null) {
            this.setPublishURL(this.config.getProperty(PUBLISH_URL_PROPERTY));
        } else if (this.publishURL != null) {
            this.config.setProperty(PUBLISH_URL_PROPERTY, this.publishURL.toString());
        }
        this.transportFactory = TransportFactory.newInstance(this.config);
        if (this.logEnabled()) {
            if (exception != null) {
                System.err.println("Ignoring exception that occurred while reading the uddi4j.properties file: " + exception);
            }
            Properties configCopyToPrint = (Properties)this.config.clone();
            String[] passwordProperties = new String[]{HTTP_BASIC_AUTH_PASSWORD_PROPERTY, HTTP_PROXY_PASSWORD_PROPERTY};
            for (int i = 0; i < passwordProperties.length; ++i) {
                if (configCopyToPrint.getProperty(passwordProperties[i]) == null) continue;
                configCopyToPrint.setProperty(passwordProperties[i], "********");
            }
            System.err.println("Configuration properties set: " + configCopyToPrint);
        }
    }

    private void overrideProperties(Properties basic, Properties overriding) {
        if (basic != null && overriding != null) {
            for (int i = 0; i < propertyNames.length; ++i) {
                if (overriding.getProperty(propertyNames[i]) == null) continue;
                basic.setProperty(propertyNames[i], overriding.getProperty(propertyNames[i]));
            }
        }
    }

    public boolean logEnabled() {
        return Boolean.valueOf(this.config.getProperty(LOGGING_PROPERTY));
    }

    public Properties getConfiguration() {
        return this.config;
    }

    public void setInquiryURL(String url) throws MalformedURLException {
        this.setInquiryURL(new URL(url));
    }

    public void setInquiryURL(URL url) {
        this.inquiryURL = url;
        if (this.inquiryURL != null) {
            this.config.setProperty(INQUIRY_URL_PROPERTY, url.toString());
        } else {
            this.config.remove(INQUIRY_URL_PROPERTY);
        }
        this.transportFactory = TransportFactory.newInstance(this.config);
    }

    public void setPublishURL(String url) throws MalformedURLException {
        this.setPublishURL(new URL(url));
    }

    public void setPublishURL(URL url) {
        this.publishURL = url;
        if (this.publishURL != null) {
            this.config.setProperty(PUBLISH_URL_PROPERTY, url.toString());
        } else {
            this.config.remove(PUBLISH_URL_PROPERTY);
        }
        this.transportFactory = TransportFactory.newInstance(this.config);
    }

    public BindingDetail find_binding(FindQualifiers findQualifiers, String serviceKey, TModelBag tModelBag, int maxRows) throws UDDIException, TransportException {
        FindBinding request = new FindBinding();
        request.setFindQualifiers(findQualifiers);
        request.setServiceKey(serviceKey);
        request.setTModelBag(tModelBag);
        if (maxRows > 0) {
            request.setMaxRows(maxRows);
        }
        return new BindingDetail(this.send(request, true));
    }

    public BusinessList find_business(String name, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        Vector<Name> names = new Vector<Name>();
        names.addElement(new Name(name));
        return this.find_business(names, null, null, null, null, findQualifiers, maxRows);
    }

    public BusinessList find_business(IdentifierBag identifierBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_business(new Vector(), null, identifierBag, null, null, findQualifiers, maxRows);
    }

    public BusinessList find_business(CategoryBag categoryBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_business(new Vector(), null, null, categoryBag, null, findQualifiers, maxRows);
    }

    public BusinessList find_business(TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_business(new Vector(), null, null, null, tModelBag, findQualifiers, maxRows);
    }

    public BusinessList find_business(DiscoveryURLs discoveryURLs, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_business(new Vector(), discoveryURLs, null, null, null, findQualifiers, maxRows);
    }

    public BusinessList find_business(Vector names, DiscoveryURLs discoveryURLs, IdentifierBag identifierBag, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        FindBusiness request = new FindBusiness();
        request.setNameVector(names);
        request.setDiscoveryURLs(discoveryURLs);
        request.setIdentifierBag(identifierBag);
        request.setCategoryBag(categoryBag);
        request.setTModelBag(tModelBag);
        request.setFindQualifiers(findQualifiers);
        if (maxRows > 0) {
            request.setMaxRows(maxRows);
        }
        return new BusinessList(this.send(request, true));
    }

    public RelatedBusinessesList find_relatedBusinesses(String businessKey, KeyedReference keyedReference, FindQualifiers findQualifiers) throws UDDIException, TransportException {
        FindRelatedBusinesses request = new FindRelatedBusinesses();
        request.setBusinessKey(businessKey);
        request.setKeyedReference(keyedReference);
        request.setFindQualifiers(findQualifiers);
        return new RelatedBusinessesList(this.send(request, true));
    }

    public RelatedBusinessesList find_relatedBusinesses(String businessKey, KeyedReference keyedReference, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        FindRelatedBusinesses request = new FindRelatedBusinesses();
        request.setBusinessKey(businessKey);
        request.setKeyedReference(keyedReference);
        request.setFindQualifiers(findQualifiers);
        if (maxRows > 0) {
            request.setMaxRows(maxRows);
        }
        return new RelatedBusinessesList(this.send(request, true));
    }

    public ServiceList find_service(String businessKey, String name, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        Vector<Name> names = new Vector<Name>();
        names.addElement(new Name(name));
        return this.find_service(businessKey, names, null, null, findQualifiers, maxRows);
    }

    public ServiceList find_service(String businessKey, CategoryBag categoryBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_service(businessKey, new Vector(), categoryBag, null, findQualifiers, maxRows);
    }

    public ServiceList find_service(String businessKey, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_service(businessKey, new Vector(), null, tModelBag, findQualifiers, maxRows);
    }

    public ServiceList find_service(String businessKey, Vector names, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        FindService request = new FindService();
        request.setBusinessKey(businessKey);
        request.setNameVector(names);
        request.setCategoryBag(categoryBag);
        request.setTModelBag(tModelBag);
        request.setFindQualifiers(findQualifiers);
        if (maxRows > 0) {
            request.setMaxRows(maxRows);
        }
        return new ServiceList(this.send(request, true));
    }

    public TModelList find_tModel(String name, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_tModel(name, null, null, findQualifiers, maxRows);
    }

    public TModelList find_tModel(CategoryBag categoryBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_tModel(null, categoryBag, null, findQualifiers, maxRows);
    }

    public TModelList find_tModel(IdentifierBag identifierBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        return this.find_tModel(null, null, identifierBag, findQualifiers, maxRows);
    }

    public TModelList find_tModel(String name, CategoryBag categoryBag, IdentifierBag identifierBag, FindQualifiers findQualifiers, int maxRows) throws UDDIException, TransportException {
        FindTModel request = new FindTModel();
        request.setName(name);
        request.setCategoryBag(categoryBag);
        request.setIdentifierBag(identifierBag);
        request.setFindQualifiers(findQualifiers);
        if (maxRows > 0) {
            request.setMaxRows(maxRows);
        }
        return new TModelList(this.send(request, true));
    }

    public BindingDetail get_bindingDetail(String bindingKey) throws UDDIException, TransportException {
        GetBindingDetail request = new GetBindingDetail();
        Vector<String> keys = new Vector<String>();
        keys.addElement(bindingKey);
        request.setBindingKeyStrings(keys);
        return new BindingDetail(this.send(request, true));
    }

    public BindingDetail get_bindingDetail(Vector bindingKeyStrings) throws UDDIException, TransportException {
        GetBindingDetail request = new GetBindingDetail();
        request.setBindingKeyStrings(bindingKeyStrings);
        return new BindingDetail(this.send(request, true));
    }

    public BusinessDetail get_businessDetail(String businessKey) throws UDDIException, TransportException {
        GetBusinessDetail request = new GetBusinessDetail();
        Vector<String> keys = new Vector<String>();
        keys.addElement(businessKey);
        request.setBusinessKeyStrings(keys);
        return new BusinessDetail(this.send(request, true));
    }

    public BusinessDetail get_businessDetail(Vector businessKeyStrings) throws UDDIException, TransportException {
        GetBusinessDetail request = new GetBusinessDetail();
        request.setBusinessKeyStrings(businessKeyStrings);
        return new BusinessDetail(this.send(request, true));
    }

    public BusinessDetailExt get_businessDetailExt(String businessKey) throws UDDIException, TransportException {
        GetBusinessDetailExt request = new GetBusinessDetailExt();
        Vector<String> keys = new Vector<String>();
        keys.addElement(businessKey);
        request.setBusinessKeyStrings(keys);
        return new BusinessDetailExt(this.send(request, true));
    }

    public BusinessDetailExt get_businessDetailExt(Vector businessKeyStrings) throws UDDIException, TransportException {
        GetBusinessDetailExt request = new GetBusinessDetailExt();
        request.setBusinessKeyStrings(businessKeyStrings);
        return new BusinessDetailExt(this.send(request, true));
    }

    public ServiceDetail get_serviceDetail(String serviceKey) throws UDDIException, TransportException {
        GetServiceDetail request = new GetServiceDetail();
        Vector<String> keys = new Vector<String>();
        keys.addElement(serviceKey);
        request.setServiceKeyStrings(keys);
        return new ServiceDetail(this.send(request, true));
    }

    public ServiceDetail get_serviceDetail(Vector serviceKeyStrings) throws UDDIException, TransportException {
        GetServiceDetail request = new GetServiceDetail();
        request.setServiceKeyStrings(serviceKeyStrings);
        return new ServiceDetail(this.send(request, true));
    }

    public TModelDetail get_tModelDetail(String tModelKey) throws UDDIException, TransportException {
        GetTModelDetail request = new GetTModelDetail();
        Vector<String> keys = new Vector<String>();
        keys.addElement(tModelKey);
        request.setTModelKeyStrings(keys);
        return new TModelDetail(this.send(request, true));
    }

    public TModelDetail get_tModelDetail(Vector tModelKeyStrings) throws UDDIException, TransportException {
        GetTModelDetail request = new GetTModelDetail();
        request.setTModelKeyStrings(tModelKeyStrings);
        return new TModelDetail(this.send(request, true));
    }

    public DispositionReport add_publisherAssertions(String authInfo, PublisherAssertion publisherAssertion) throws UDDIException, TransportException {
        Vector<PublisherAssertion> pubVector = new Vector<PublisherAssertion>();
        pubVector.addElement(publisherAssertion);
        return this.add_publisherAssertions(authInfo, pubVector);
    }

    public DispositionReport add_publisherAssertions(String authInfo, Vector publisherAssertion) throws UDDIException, TransportException {
        AddPublisherAssertions request = new AddPublisherAssertions();
        request.setAuthInfo(authInfo);
        request.setPublisherAssertionVector(publisherAssertion);
        return new DispositionReport(this.send(request, false));
    }

    public AssertionStatusReport get_assertionStatusReport(String authInfo, String completionStatus) throws UDDIException, TransportException {
        return this.get_assertionStatusReport(authInfo, new CompletionStatus(completionStatus));
    }

    public AssertionStatusReport get_assertionStatusReport(String authInfo, CompletionStatus completionStatus) throws UDDIException, TransportException {
        GetAssertionStatusReport request = new GetAssertionStatusReport();
        request.setAuthInfo(authInfo);
        request.setCompletionStatus(completionStatus);
        return new AssertionStatusReport(this.send(request, false));
    }

    public PublisherAssertions get_publisherAssertions(String authInfo) throws UDDIException, TransportException {
        GetPublisherAssertions request = new GetPublisherAssertions();
        request.setAuthInfo(authInfo);
        return new PublisherAssertions(this.send(request, false));
    }

    public DispositionReport delete_binding(String authInfo, String bindingKey) throws UDDIException, TransportException {
        DeleteBinding request = new DeleteBinding();
        request.setAuthInfo(authInfo);
        Vector<String> keys = new Vector<String>();
        keys.addElement(bindingKey);
        request.setBindingKeyStrings(keys);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_binding(String authInfo, Vector bindingKeyStrings) throws UDDIException, TransportException {
        DeleteBinding request = new DeleteBinding();
        request.setAuthInfo(authInfo);
        request.setBindingKeyStrings(bindingKeyStrings);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_business(String authInfo, String businessKey) throws UDDIException, TransportException {
        DeleteBusiness request = new DeleteBusiness();
        request.setAuthInfo(authInfo);
        Vector<String> keys = new Vector<String>();
        keys.addElement(businessKey);
        request.setBusinessKeyStrings(keys);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_business(String authInfo, Vector businessKeyStrings) throws UDDIException, TransportException {
        DeleteBusiness request = new DeleteBusiness();
        request.setAuthInfo(authInfo);
        request.setBusinessKeyStrings(businessKeyStrings);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_service(String authInfo, String serviceKey) throws UDDIException, TransportException {
        DeleteService request = new DeleteService();
        request.setAuthInfo(authInfo);
        Vector<String> keys = new Vector<String>();
        keys.addElement(serviceKey);
        request.setServiceKeyStrings(keys);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_service(String authInfo, Vector serviceKeyStrings) throws UDDIException, TransportException {
        DeleteService request = new DeleteService();
        request.setAuthInfo(authInfo);
        request.setServiceKeyStrings(serviceKeyStrings);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_tModel(String authInfo, String tModelKey) throws UDDIException, TransportException {
        DeleteTModel request = new DeleteTModel();
        request.setAuthInfo(authInfo);
        Vector<String> keys = new Vector<String>();
        keys.addElement(tModelKey);
        request.setTModelKeyStrings(keys);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_tModel(String authInfo, Vector tModelKeyStrings) throws UDDIException, TransportException {
        DeleteTModel request = new DeleteTModel();
        request.setAuthInfo(authInfo);
        request.setTModelKeyStrings(tModelKeyStrings);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport delete_publisherAssertions(String authInfo, PublisherAssertion publisherAssertion) throws UDDIException, TransportException {
        Vector<PublisherAssertion> pubVector = new Vector<PublisherAssertion>();
        pubVector.addElement(publisherAssertion);
        return this.delete_publisherAssertions(authInfo, pubVector);
    }

    public DispositionReport delete_publisherAssertions(String authInfo, Vector publisherAssertion) throws UDDIException, TransportException {
        DeletePublisherAssertions request = new DeletePublisherAssertions();
        request.setAuthInfo(authInfo);
        request.setPublisherAssertionVector(publisherAssertion);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport discard_authToken(String authInfo) throws UDDIException, TransportException {
        DiscardAuthToken request = new DiscardAuthToken();
        request.setAuthInfo(authInfo);
        return new DispositionReport(this.send(request, false));
    }

    public DispositionReport discard_authToken(AuthInfo authInfo) throws UDDIException, TransportException {
        DiscardAuthToken request = new DiscardAuthToken();
        request.setAuthInfo(authInfo);
        return new DispositionReport(this.send(request, false));
    }

    public AuthToken get_authToken(String userid, String cred) throws UDDIException, TransportException {
        GetAuthToken request = new GetAuthToken();
        request.setUserID(userid);
        request.setCred(cred);
        return new AuthToken(this.send(request, false));
    }

    public RegisteredInfo get_registeredInfo(String authInfo) throws UDDIException, TransportException {
        GetRegisteredInfo request = new GetRegisteredInfo();
        request.setAuthInfo(authInfo);
        return new RegisteredInfo(this.send(request, false));
    }

    public BindingDetail save_binding(String authInfo, Vector bindingTemplates) throws UDDIException, TransportException {
        SaveBinding request = new SaveBinding();
        request.setAuthInfo(authInfo);
        request.setBindingTemplateVector(bindingTemplates);
        return new BindingDetail(this.send(request, false));
    }

    public BusinessDetail save_business(String authInfo, Vector businessEntities) throws UDDIException, TransportException {
        SaveBusiness request = new SaveBusiness();
        request.setAuthInfo(authInfo);
        request.setBusinessEntityVector(businessEntities);
        return new BusinessDetail(this.send(request, false));
    }

    public BusinessDetail save_business(String authInfo, UploadRegister[] uploadRegisters) throws UDDIException, TransportException {
        SaveBusiness request = new SaveBusiness();
        Vector<UploadRegister> keys = new Vector<UploadRegister>(Arrays.asList(uploadRegisters));
        request.setAuthInfo(authInfo);
        request.setUploadRegisterVector(keys);
        return new BusinessDetail(this.send(request, false));
    }

    public ServiceDetail save_service(String authInfo, Vector businessServices) throws UDDIException, TransportException {
        SaveService request = new SaveService();
        request.setAuthInfo(authInfo);
        request.setBusinessServiceVector(businessServices);
        return new ServiceDetail(this.send(request, false));
    }

    public TModelDetail save_tModel(String authInfo, Vector tModels) throws UDDIException, TransportException {
        SaveTModel request = new SaveTModel();
        request.setAuthInfo(authInfo);
        request.setTModelVector(tModels);
        return new TModelDetail(this.send(request, false));
    }

    public TModelDetail save_tModel(String authInfo, UploadRegister[] uploadRegisters) throws UDDIException, TransportException {
        SaveTModel request = new SaveTModel();
        request.setAuthInfo(authInfo);
        Vector<UploadRegister> keys = new Vector<UploadRegister>(Arrays.asList(uploadRegisters));
        request.setUploadRegisterVector(keys);
        return new TModelDetail(this.send(request, false));
    }

    public PublisherAssertions set_publisherAssertions(String authInfo, PublisherAssertion pub) throws UDDIException, TransportException {
        Vector<PublisherAssertion> pubVector = new Vector<PublisherAssertion>();
        pubVector.addElement(pub);
        return this.set_publisherAssertions(authInfo, pubVector);
    }

    public PublisherAssertions set_publisherAssertions(String authInfo, Vector publisherAssertion) throws UDDIException, TransportException {
        SetPublisherAssertions request = new SetPublisherAssertions();
        request.setAuthInfo(authInfo);
        request.setPublisherAssertionVector(publisherAssertion);
        return new PublisherAssertions(this.send(request, false));
    }

    public DispositionReport validate_values_businessEntity(Vector businessEntity) throws UDDIException, TransportException {
        ValidateValues request = new ValidateValues();
        request.setBusinessEntityVector(businessEntity);
        return new DispositionReport(this.send(request, true));
    }

    public DispositionReport validate_values_businessService(Vector businessService) throws UDDIException, TransportException {
        ValidateValues request = new ValidateValues();
        request.setBusinessServiceVector(businessService);
        return new DispositionReport(this.send(request, true));
    }

    public DispositionReport validate_values_tModel(Vector tModel) throws UDDIException, TransportException {
        ValidateValues request = new ValidateValues();
        request.setTModelVector(tModel);
        return new DispositionReport(this.send(request, true));
    }

    public Element send(UDDIElement el, boolean inquiry) throws TransportException {
        Element result = null;
        result = inquiry ? this.transportFactory.getTransport().send(el, this.inquiryURL) : this.transportFactory.getTransport().send(el, this.publishURL);
        return result;
    }

    public Element send(Element el, boolean inquiry) throws TransportException {
        Element result = null;
        result = inquiry ? this.transportFactory.getTransport().send(el, this.inquiryURL) : this.transportFactory.getTransport().send(el, this.publishURL);
        return result;
    }
}

