/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaCopyProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaCopyRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.NewNameQueries;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgQueries;

public class ReorgCopyStarter {
    private final JavaCopyProcessor fCopyProcessor;

    public static ReorgCopyStarter create(IJavaScriptElement[] javaElements, IResource[] resources, IJavaScriptElement destination) throws JavaScriptModelException {
        Assert.isNotNull((Object)javaElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        IReorgPolicy.ICopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, javaElements);
        if (!copyPolicy.canEnable()) {
            return null;
        }
        JavaCopyProcessor copyProcessor = new JavaCopyProcessor(copyPolicy);
        if (!copyProcessor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyProcessor);
    }

    public static ReorgCopyStarter create(IJavaScriptElement[] javaElements, IResource[] resources, IResource destination) throws JavaScriptModelException {
        Assert.isNotNull((Object)javaElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        IReorgPolicy.ICopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, javaElements);
        if (!copyPolicy.canEnable()) {
            return null;
        }
        JavaCopyProcessor copyProcessor = new JavaCopyProcessor(copyPolicy);
        if (!copyProcessor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgCopyStarter(copyProcessor);
    }

    private ReorgCopyStarter(JavaCopyProcessor copyProcessor) {
        Assert.isNotNull((Object)copyProcessor);
        this.fCopyProcessor = copyProcessor;
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
        this.fCopyProcessor.setNewNameQueries(new NewNameQueries(parent));
        this.fCopyProcessor.setReorgQueries(new ReorgQueries(parent));
        new RefactoringExecutionHelper((Refactoring)new JavaCopyRefactoring(this.fCopyProcessor), RefactoringCore.getConditionCheckingFailedSeverity(), 5, parent, (IRunnableContext)context).perform(false, false);
    }
}

