/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IUnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class OneToManyUniDirRelation
extends OneToManyRelation
implements IUnidirectionalRelation {
    public OneToManyUniDirRelation(IJPAEditorFeatureProvider fp, PersistentType owner, PersistentType inverse, String ownerAttributeName, boolean createAttribs) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        if (createAttribs) {
            this.createRelation(fp);
        }
    }

    @Override
    public PersistentAttribute getAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    @Override
    public void setAnnotatedAttribute(PersistentAttribute annotatedAttribute) {
        this.ownerAnnotatedAttribute = annotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp) {
        boolean isMap = JPADiagramPropertyPage.isMapType(this.owner.getJpaProject().getProject());
        String mapKeyType = this.getMapKeyType(isMap, this.inverse);
        this.ownerAnnotatedAttribute = JPAEditorUtil.addAnnotatedAttribute(this.owner, this.inverse, true, mapKeyType);
        JpaArtifactFactory.instance().addOneToManyUnidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, isMap);
    }

    @Override
    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.UNI;
    }

    private String getMapKeyType(boolean isMap, PersistentType jpt) {
        return isMap ? JpaArtifactFactory.instance().getIdType(jpt) : null;
    }
}

