/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.FunctionScopeExtension;
import org.eclipse.wst.jsdt.chromium.JsDeclarativeVariable;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsObjectProperty;
import org.eclipse.wst.jsdt.chromium.JsScope;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugElementImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ExpressionTracker;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrame;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ValueBase;

public abstract class Variable
extends DebugElementImpl.WithEvaluate
implements IVariable {
    private static final IWatchExpressionFactoryAdapter EXPRESSION_FACTORY_ADAPTER = new IWatchExpressionFactoryAdapter(){

        public String createWatchExpression(IVariable variable) throws CoreException {
            Variable castVariable = (Variable)variable;
            String expressionText = castVariable.createWatchExpression();
            if (expressionText == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", Messages.Variable_CANNOT_BUILD_EXPRESSION));
            }
            return expressionText;
        }
    };
    private static final String JAVASCRIPT_REFERENCE_TYPE_NAME = "";

    public static Variable forRealValue(EvaluateContext evaluateContext, JsVariable jsVariable, boolean isInternalProperty, ExpressionTracker.Node trackerNode) {
        ValueBase value;
        JsValue jsValue = jsVariable.getValue();
        if (jsValue == null) {
            JsObjectProperty objectProperty = jsVariable.asObjectProperty();
            if (objectProperty == null) {
                value = new ValueBase.ErrorMessageValue(evaluateContext, "Variable value is unavailable");
            } else {
                value = Variable.calculateAccessorPropertyBlocking(objectProperty, evaluateContext, trackerNode);
                if (value == null) {
                    value = new ValueBase.ErrorMessageValue(evaluateContext, "Unreadable object property");
                }
            }
        } else {
            value = Value.create(evaluateContext, jsValue, trackerNode);
        }
        return new Real(evaluateContext, jsVariable, value, isInternalProperty, trackerNode);
    }

    private static ValueBase calculateAccessorPropertyBlocking(JsObjectProperty property, EvaluateContext evaluateContext, ExpressionTracker.Node expressionTrackerNode) {
        if (property.getGetterAsFunction() == null) {
            return new ValueBase.ErrorMessageValue(evaluateContext, "Property has undefined getter");
        }
        class Callback
        implements JsEvaluateContext.EvaluateCallback {
            ValueBase valueBase = null;
            private final /* synthetic */ EvaluateContext val$evaluateContext;
            private final /* synthetic */ ExpressionTracker.Node val$expressionTrackerNode;

            Callback(EvaluateContext evaluateContext, ExpressionTracker.Node node) {
                this.val$evaluateContext = evaluateContext;
                this.val$expressionTrackerNode = node;
            }

            public void success(JsEvaluateContext.ResultOrException result) {
                this.valueBase = (ValueBase)((Object)result.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<ValueBase>(){

                    public ValueBase visitResult(JsValue value) {
                        return Value.create(val$evaluateContext, value, val$expressionTrackerNode);
                    }

                    public ValueBase visitException(JsValue exception) {
                        return new ValueBase.ErrorMessageValue(val$evaluateContext, "Evaluate failure", exception);
                    }
                }));
            }

            public void failure(Exception cause) {
                this.valueBase = new ValueBase.ErrorMessageValue(this.val$evaluateContext, "Failed to evaluate property value: " + cause.getMessage());
            }
        }
        Callback callback = new Callback(evaluateContext, expressionTrackerNode);
        CallbackSemaphore callbackSemaphore = new CallbackSemaphore();
        RelayOk relayOk = property.evaluateGet((JsEvaluateContext.EvaluateCallback)callback, (SyncCallback)callbackSemaphore);
        callbackSemaphore.acquireDefault(relayOk);
        return callback.valueBase;
    }

    public static Variable forException(EvaluateContext evaluateContext, JsValue exceptionValue) {
        Value value = Value.create(evaluateContext, exceptionValue, ExpressionTracker.NO_EXPRESSION_NODE);
        return new Virtual(evaluateContext, "<exception>", JAVASCRIPT_REFERENCE_TYPE_NAME, value, null);
    }

    public static Variable forObjectScope(EvaluateContext evaluateContext, JsScope.ObjectBased scope, ExpressionTracker.Node expressionNode) {
        String scopeVariableName = "<" + scope.getType() + ">";
        Value value = Value.create(evaluateContext, (JsValue)scope.getScopeObject(), expressionNode);
        return Variable.forScopeImpl(evaluateContext, scopeVariableName, value);
    }

    private static Variable forScopeImpl(EvaluateContext evaluateContext, String scopeName, ValueBase scopeValue) {
        return new Virtual(evaluateContext, scopeName, "<scope>", scopeValue, null);
    }

    public static Variable forFunctionScopes(EvaluateContext evaluateContext, final JsFunction jsFunction, final FunctionScopeExtension functionScopeExtension) {
        ValueBase.ValueWithLazyVariables value = new ValueBase.ValueWithLazyVariables(evaluateContext){

            public String getReferenceTypeName() throws DebugException {
                return "<function scope>";
            }

            public boolean isAllocated() throws DebugException {
                return true;
            }

            public boolean hasVariables() throws DebugException {
                return !functionScopeExtension.getScopes(jsFunction).isEmpty();
            }

            @Override
            protected IVariable[] calculateVariables() {
                List list = functionScopeExtension.getScopes(jsFunction);
                List reverseList = this.reverseList(list);
                return StackFrame.wrapScopes(this.getEvaluateContext(), reverseList, null, ExpressionTracker.FUNCTION_SCOPE_FACTORY);
            }

            @Override
            public Value asRealValue() {
                return null;
            }

            @Override
            public String getValueString() {
                return Variable.JAVASCRIPT_REFERENCE_TYPE_NAME;
            }

            private <T> List<T> reverseList(final List<T> input) {
                return new AbstractList<T>(){

                    @Override
                    public T get(int index) {
                        return input.get(input.size() - index - 1);
                    }

                    @Override
                    public int size() {
                        return input.size();
                    }
                };
            }
        };
        return Variable.forScopeImpl(evaluateContext, "<function scope>", value);
    }

    public static Variable forEvaluateExpression(EvaluateContext evaluateContext, JsValue jsValue, String expression) {
        ExpressionTracker.Node expressionTrackerNode = ExpressionTracker.createExpressionNode(expression);
        Value value = Value.create(evaluateContext, jsValue, expressionTrackerNode);
        return new Virtual(evaluateContext, expression, JAVASCRIPT_REFERENCE_TYPE_NAME, value, expressionTrackerNode.calculateQualifiedName());
    }

    protected Variable(EvaluateContext evaluateContext) {
        super(evaluateContext);
    }

    public abstract String getName();

    public abstract String getReferenceTypeName();

    public abstract ValueBase getValue();

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    protected abstract String createWatchExpression();

    public abstract Real asRealVariable();

    @Override
    public Object getAdapter(Class adapter) {
        if (IWatchExpressionFactoryAdapter.class == adapter) {
            return EXPRESSION_FACTORY_ADAPTER;
        }
        return super.getAdapter(adapter);
    }

    private static String getExceptionMessage(JsValue exception, JsEvaluateContext evaluateContext) {
        String expression = "(e instanceof Error) ? e.message : String(e)";
        Map<String, JsValue> context = Collections.singletonMap("e", exception);
        class CallbackImpl
        implements JsEvaluateContext.EvaluateCallback {
            String result = "<exception message not available>";

            CallbackImpl() {
            }

            public void success(JsEvaluateContext.ResultOrException resultOrException) {
                String message = (String)resultOrException.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<String>(){

                    public String visitResult(JsValue value) {
                        return value.getValueString();
                    }

                    public String visitException(JsValue exception) {
                        return null;
                    }
                });
                if (message != null) {
                    this.result = message;
                }
            }

            public void failure(Exception cause) {
            }
        }
        CallbackImpl callback = new CallbackImpl();
        evaluateContext.evaluateSync(expression, context, (JsEvaluateContext.EvaluateCallback)callback);
        return callback.result;
    }

    public static class Real
    extends Variable {
        private final JsVariable jsVariable;
        private final ExpressionTracker.Node expressionTrackerNode;
        private volatile ValueBase value;
        private final boolean isInternalProperty;

        Real(EvaluateContext evaluateContext, JsVariable jsVariable, ValueBase value, boolean isInternalProperty, ExpressionTracker.Node expressionTrackerNode) {
            super(evaluateContext);
            this.jsVariable = jsVariable;
            this.value = value;
            this.isInternalProperty = isInternalProperty;
            this.expressionTrackerNode = expressionTrackerNode;
        }

        @Override
        public String getName() {
            return this.jsVariable.getName();
        }

        @Override
        public ValueBase getValue() {
            return this.value;
        }

        @Override
        public String getReferenceTypeName() {
            return Variable.JAVASCRIPT_REFERENCE_TYPE_NAME;
        }

        @Override
        public Real asRealVariable() {
            return this;
        }

        public JsVariable getJsVariable() {
            return this.jsVariable;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            ValueBase valueBase = ValueBase.cast(value);
            if (valueBase == null) {
                return false;
            }
            Value realValue = valueBase.asRealValue();
            return realValue != null;
        }

        public boolean verifyValue(String expression) throws DebugException {
            JsEvaluateContext.ResultOrException resultOrException = this.evaluateExpressionString(expression);
            return (Boolean)resultOrException.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<Boolean>(){

                public Boolean visitResult(JsValue value) {
                    return true;
                }

                public Boolean visitException(JsValue exception) {
                    return false;
                }
            });
        }

        public void setValue(IValue value) throws DebugException {
            ValueBase valueBase = ValueBase.cast(value);
            if (valueBase == null) {
                throw new IllegalArgumentException("Unrecognized type of value");
            }
            Value realValue = valueBase.asRealValue();
            if (realValue == null) {
                throw new IllegalArgumentException("Not a real value");
            }
            JsValue jsValue = realValue.getJsValue();
            this.setValue(jsValue);
        }

        public void setValue(String expression) throws DebugException {
            JsEvaluateContext.ResultOrException newValueOrException = this.evaluateExpressionString(expression);
            if (newValueOrException.getResult() == null) {
                String message = Variable.getExceptionMessage(newValueOrException.getException(), this.getEvaluateContext().getJsEvaluateContext());
                Status status = new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", 5010, "JavaScript compile exception: " + message, null);
                throw new DebugException((IStatus)status);
            }
            this.setValue(newValueOrException.getResult());
        }

        private JsEvaluateContext.ResultOrException evaluateExpressionString(String expression) throws DebugException {
            class CallbackImpl
            implements JsEvaluateContext.EvaluateCallback {
                JsEvaluateContext.ResultOrException resultOrException = null;
                Exception cause = null;

                CallbackImpl() {
                }

                public void success(JsEvaluateContext.ResultOrException resultOrException) {
                    this.resultOrException = resultOrException;
                }

                public void failure(Exception cause) {
                    this.cause = cause;
                }
            }
            CallbackImpl callback = new CallbackImpl();
            JsEvaluateContext evaluateContext = this.getEvaluateContext().getJsEvaluateContext();
            evaluateContext.evaluateSync(expression, null, (JsEvaluateContext.EvaluateCallback)callback);
            if (callback.resultOrException != null) {
                return callback.resultOrException;
            }
            Status status = new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", 5010, "Failed to execute remote command", (Throwable)callback.cause);
            throw new DebugException((IStatus)status);
        }

        private void setValue(JsValue newValue) throws DebugException {
            ValueChanger changer = this.createValueChanger();
            if (changer == null) {
                throw new UnsupportedOperationException();
            }
            ValueChanger.Callback callback = new ValueChanger.Callback();
            CallbackSemaphore syncCallback = new CallbackSemaphore();
            RelayOk relayOk = changer.setValue(newValue, callback, syncCallback);
            syncCallback.acquireDefault(relayOk);
            if (!callback.successful) {
                Status status;
                if (callback.exception == null) {
                    status = new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", 5010, "Failed to execute remote command", (Throwable)callback.cause);
                } else {
                    String message = Variable.getExceptionMessage(callback.exception, this.getEvaluateContext().getJsEvaluateContext());
                    status = new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", 5010, "JavaScript exception: " + message, null);
                }
                throw new DebugException((IStatus)status);
            }
            this.value = Value.create(this.getEvaluateContext(), this.jsVariable.getValue(), this.expressionTrackerNode);
            DebugEvent event = new DebugEvent((Object)this, 16, 512);
            DebugTargetImpl.fireDebugEvent(event);
        }

        public boolean supportsValueModification() {
            return this.createValueChanger() != null;
        }

        @Override
        public String createWatchExpression() {
            return this.expressionTrackerNode.calculateQualifiedName();
        }

        public String createHolderWatchExpression() {
            return this.expressionTrackerNode.calculateParentQualifiedName();
        }

        private ValueChanger createValueChanger() {
            final JsDeclarativeVariable declarative = this.jsVariable.asDeclarativeVariable();
            if (declarative != null) {
                if (!declarative.isMutable()) {
                    return null;
                }
                return new ValueChanger(){

                    @Override
                    RelayOk setValue(JsValue newValue, final ValueChanger.Callback callback, CallbackSemaphore syncCallback) {
                        JsDeclarativeVariable.SetValueCallback rawCallback = new JsDeclarativeVariable.SetValueCallback(){

                            public void success() {
                                callback.success();
                            }

                            public void failure(Exception cause) {
                                callback.failure(cause);
                            }
                        };
                        return declarative.setValue(newValue, rawCallback, (SyncCallback)syncCallback);
                    }
                };
            }
            JsObjectProperty property = this.jsVariable.asObjectProperty();
            if (property != null) {
                return null;
            }
            return null;
        }

        private static abstract class ValueChanger {
            private ValueChanger() {
            }

            abstract RelayOk setValue(JsValue var1, Callback var2, CallbackSemaphore var3);

            static class Callback {
                boolean successful = false;
                JsValue exception = null;
                Exception cause = null;

                Callback() {
                }

                void success() {
                    this.successful = true;
                }

                void exceptionThrown(JsValue exception) {
                    this.exception = exception;
                }

                void failure(Exception cause) {
                    this.cause = cause;
                }
            }
        }
    }

    private static class Virtual
    extends Variable {
        private final String name;
        private final String referenceTypeName;
        private final String watchExpression;
        private final ValueBase value;

        Virtual(EvaluateContext evaluateContext, String name, String referenceTypeName, ValueBase value, String watchExpression) {
            super(evaluateContext);
            this.name = name;
            this.value = value;
            this.referenceTypeName = referenceTypeName;
            this.watchExpression = watchExpression;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ValueBase getValue() {
            return this.value;
        }

        @Override
        public String getReferenceTypeName() {
            return this.referenceTypeName;
        }

        @Override
        public Real asRealVariable() {
            return null;
        }

        @Override
        protected String createWatchExpression() {
            return this.watchExpression;
        }

        public boolean supportsValueModification() {
            return false;
        }

        public void setValue(String expression) throws DebugException {
            throw new UnsupportedOperationException();
        }

        public void setValue(IValue value) throws DebugException {
            throw new UnsupportedOperationException();
        }

        public boolean verifyValue(String expression) throws DebugException {
            throw new UnsupportedOperationException();
        }

        public boolean verifyValue(IValue value) throws DebugException {
            throw new UnsupportedOperationException();
        }
    }
}

