/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JDTBeanMethod {
    private final IMethod method;
    private final String resolvedMethodSignatureErased;
    private final String resolvedMethodSignatureUnerased;

    JDTBeanMethod(IMethod method, String resolvedMethodSignatureErased, String resolvedMethodSignatureUnerased) {
        this.method = method;
        this.resolvedMethodSignatureErased = resolvedMethodSignatureErased;
        this.resolvedMethodSignatureUnerased = resolvedMethodSignatureUnerased;
    }

    public IType getDeclaringType() {
        return this.method.getDeclaringType();
    }

    public IMethod getMethod() {
        return this.method;
    }

    public String getElementName() {
        return this.method.getElementName();
    }

    public boolean isConstructor() throws JavaModelException {
        return this.method.isConstructor();
    }

    public int getFlags() throws JavaModelException {
        return this.method.getFlags();
    }

    public String getResolvedSignatureErased() {
        return this.resolvedMethodSignatureErased;
    }

    public String[] getUnresolvedParameterTypesUnerased() {
        return this.method.getParameterTypes();
    }

    public String[] getResolvedParameterTypesUnerased() {
        return Signature.getParameterTypes((String)this.resolvedMethodSignatureUnerased);
    }

    public String getResolvedReturnTypeUnerased() {
        return Signature.getReturnType((String)this.resolvedMethodSignatureUnerased);
    }

    public String getUnresolvedReturnTypeUnerased() throws JavaModelException {
        return this.method.getReturnType();
    }

    public String toString() {
        return "JDTBeanMethod [name=" + this.getElementName() + "erasedSignature=" + this.resolvedMethodSignatureErased + "unerasedSignature=" + this.resolvedMethodSignatureUnerased + "]";
    }
}

