/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.uddiregistry.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.ws.internal.uddiregistry.UDDIRegistryMessages;
import org.eclipse.jst.ws.internal.uddiregistry.wizard.PrivateUDDIRegistryType;
import org.eclipse.jst.ws.internal.uddiregistry.wizard.PrivateUDDIRegistryTypeRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class PrivateUDDISelectionWidget
extends SimpleWidgetDataContributor {
    private Listener statusListener;
    private Button deployRadio_;
    private Label typesLabel_;
    private Combo typesCombo_;
    private Button updateRadio_;
    private Button removeRadio_;
    private PrivateUDDIRegistryType[] types_;
    private PrivateUDDIRegistryType installedType_;
    private final String INFOPOP_PUPR_PRIVATE_UDDI_PAGE = "org.eclipse.jst.ws.uddiregistry.pupr0001";
    private final String INFOPOP_PUPR_PRIVATE_UDDI_TYPE = "org.eclipse.jst.ws.uddiregistry.pupr0002";
    private final String INFOPOP_PUPR_DEPLOY_PRIVATE_UDDI = "org.eclipse.jst.ws.uddiregistry.pupr0003";
    private final String INFOPOP_PUPR_UPDATE_PRIVATE_UDDI = "org.eclipse.jst.ws.uddiregistry.pupr0005";
    private final String INFOPOP_PUPR_REMOVE_PRIVATE_UDDI = "org.eclipse.jst.ws.uddiregistry.pupr0004";

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener = statusListener;
        parent.setToolTipText(UDDIRegistryMessages.TOOLTIP_PUPR_PRIVATE_UDDI_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jst.ws.uddiregistry.pupr0001");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                PrivateUDDISelectionWidget.this.handleWidgetEvent(event);
            }
        };
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        this.deployRadio_ = new Button(parent, 16);
        this.deployRadio_.setText(UDDIRegistryMessages.BUTTON_DEPLOY_UDDI_REGISTRY);
        this.deployRadio_.setSelection(true);
        this.deployRadio_.addListener(13, listener);
        this.deployRadio_.setToolTipText(UDDIRegistryMessages.TOOLTIP_PUPR_DEPLOY_PRIVATE_UDDI);
        helpSystem.setHelp((Control)this.deployRadio_, "org.eclipse.jst.ws.uddiregistry.pupr0003");
        Composite typeComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 5;
        gl.verticalSpacing = 15;
        gl.marginWidth = 20;
        typeComposite.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        typeComposite.setLayoutData((Object)gd);
        this.typesLabel_ = new Label(typeComposite, 64);
        this.typesLabel_.setText(UDDIRegistryMessages.LABEL_PRIVATE_UDDI_REGISTRY_TYPES);
        this.typesLabel_.setToolTipText(UDDIRegistryMessages.TOOLTIP_PUPR_PRIVATE_UDDI_TYPE);
        helpSystem.setHelp((Control)this.typesLabel_, "org.eclipse.jst.ws.uddiregistry.pupr0002");
        this.typesCombo_ = new Combo(typeComposite, 12);
        gd = new GridData(768);
        this.typesCombo_.setLayoutData((Object)gd);
        this.typesCombo_.addListener(13, listener);
        this.typesCombo_.setToolTipText(UDDIRegistryMessages.TOOLTIP_PUPR_PRIVATE_UDDI_TYPE);
        helpSystem.setHelp((Control)this.typesCombo_, "org.eclipse.jst.ws.uddiregistry.pupr0002");
        this.updateRadio_ = new Button(parent, 16);
        this.updateRadio_.setText(UDDIRegistryMessages.BUTTON_UPDATE_UDDI_REGISTRY);
        this.updateRadio_.setSelection(false);
        this.updateRadio_.addListener(13, listener);
        this.updateRadio_.setToolTipText(UDDIRegistryMessages.TOOLTIP_PUPR_UPDATE_PRIVATE_UDDI);
        helpSystem.setHelp((Control)this.updateRadio_, "org.eclipse.jst.ws.uddiregistry.pupr0005");
        this.removeRadio_ = new Button(parent, 16);
        this.removeRadio_.setText(UDDIRegistryMessages.BUTTON_REMOVE_UDDI_REGISTRY);
        this.removeRadio_.setSelection(false);
        this.removeRadio_.addListener(13, listener);
        this.removeRadio_.setToolTipText(UDDIRegistryMessages.TOOLTIP_PUPR_REMOVE_PRIVATE_UDDI);
        helpSystem.setHelp((Control)this.removeRadio_, "org.eclipse.jst.ws.uddiregistry.pupr0004");
        this.loadTypes();
        this.init();
        return this;
    }

    private final void loadTypes() {
        this.types_ = PrivateUDDIRegistryTypeRegistry.getInstance().getTypes();
    }

    private final void init() {
        int i = 0;
        while (i < this.types_.length) {
            if (this.types_[i] != null) {
                this.typesCombo_.add(this.types_[i].getName());
                if (this.types_[i].isPrivateUDDIRegistryInstalled()) {
                    this.installedType_ = this.types_[i];
                }
            }
            ++i;
        }
        if (this.typesCombo_.getItemCount() > 0) {
            this.typesCombo_.setText(this.typesCombo_.getItem(0));
        }
        if (this.installedType_ != null) {
            this.updateRadio_.setEnabled(true);
            this.removeRadio_.setEnabled(true);
        } else {
            this.updateRadio_.setEnabled(false);
            this.removeRadio_.setEnabled(false);
        }
    }

    private void handleWidgetEvent(Event event) {
        if (event.widget == this.removeRadio_ || event.widget == this.updateRadio_) {
            boolean isUpdateOrRemoveSelected = ((Button)event.widget).getSelection();
            this.typesLabel_.setEnabled(!isUpdateOrRemoveSelected);
            this.typesCombo_.setEnabled(!isUpdateOrRemoveSelected);
        } else if (event.widget == this.deployRadio_) {
            boolean isDeploySelected = ((Button)event.widget).getSelection();
            this.typesLabel_.setEnabled(isDeploySelected);
            this.typesCombo_.setEnabled(isDeploySelected);
        }
        this.statusListener.handleEvent(event);
    }

    public PrivateUDDIRegistryType getPrivateUDDIRegistryType() {
        if (this.deployRadio_.getSelection()) {
            String selectedRegistryName = this.typesCombo_.getText();
            int i = 0;
            while (i < this.types_.length) {
                if (selectedRegistryName.equals(this.types_[i].getName())) {
                    return this.types_[i];
                }
                ++i;
            }
            return null;
        }
        return this.installedType_;
    }

    public byte getOperationType() {
        if (this.deployRadio_.getSelection()) {
            return 0;
        }
        if (this.updateRadio_.getSelection()) {
            return 1;
        }
        if (this.removeRadio_.getSelection()) {
            return 2;
        }
        return 0;
    }

    public IStatus getStatus() {
        PrivateUDDIRegistryType privateUDDIRegistryType = this.getPrivateUDDIRegistryType();
        if (privateUDDIRegistryType != null) {
            return privateUDDIRegistryType.getOperationStatus(this.getOperationType());
        }
        return StatusUtils.errorStatus((String)UDDIRegistryMessages.MSG_ERROR_NO_UDDI_REGISTRY_AVAILABLE);
    }
}

