/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import java.util.List;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.TagCreationAttribute;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.TagCreationInfo;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public final class MetadataTagDropSourceData
implements ITagDropSourceData {
    private final IDOMModel _model;
    private final TagCreationInfo _tagCreationInfo;
    private final ITagDropSourceData _delegate;

    public MetadataTagDropSourceData(ITagDropSourceData creationProvider, IDOMModel model) {
        this._delegate = creationProvider;
        this._model = model;
        this._tagCreationInfo = this.getTagCreationInfo();
    }

    public List<TagCreationAttribute> getAttributes() {
        if (this._tagCreationInfo != null) {
            return this._tagCreationInfo.getAttributes();
        }
        return null;
    }

    public String getTemplate() {
        if (this._tagCreationInfo != null) {
            return (String)this._tagCreationInfo.getTemplate();
        }
        return null;
    }

    @Override
    public String getDefaultPrefix() {
        return this._delegate.getDefaultPrefix();
    }

    @Override
    public String getTagName() {
        return this._delegate.getTagName();
    }

    @Override
    public String getNamespace() {
        return this._delegate.getNamespace();
    }

    private TagCreationInfo getTagCreationInfo() {
        IMetaDataModelContext metadataContext = CommandUtil.getMetadataModelContext(this.getNamespace(), this._model);
        TagCreationInfo tagCreationInfo = null;
        String id = this.getId();
        if (metadataContext != null && id != null) {
            tagCreationInfo = MetadataTagDropSourceData.createCreationInfo(metadataContext, id, this.getTagName());
        }
        return tagCreationInfo;
    }

    @Override
    public String getId() {
        return this._delegate.getId();
    }

    static TagCreationInfo createCreationInfo(IMetaDataModelContext metaDataContext, String id, String tagName) {
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery((IMetaDataDomainContext)metaDataContext);
        Model model = query.findTagLibraryModel(metaDataContext.getModelIdentifier());
        if (model != null) {
            PaletteInfos pis;
            PaletteInfo pi;
            Trait trait = query.findTrait((Entity)model, "paletteInfos");
            if (trait != null && (pi = (pis = (PaletteInfos)trait.getValue()).findPaletteInfoById(id)) != null) {
                return pi.getTagCreation();
            }
            Entity tag = query.findTagEntity(model, tagName);
            if (tag != null && (trait = query.findTrait(tag, "tag-create")) != null && trait.getValue() != null) {
                return (TagCreationInfo)trait.getValue();
            }
        }
        return null;
    }
}

