/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.reference.ModifiableIntReference;
import org.eclipse.jpt.common.utility.tests.internal.reference.IntReferenceTests;

public abstract class ModifiableIntReferenceTests
extends IntReferenceTests {
    public ModifiableIntReferenceTests(String name) {
        super(name);
    }

    protected ModifiableIntReference buildIntReference() {
        return this.buildIntReference(0);
    }

    protected abstract ModifiableIntReference buildIntReference(int var1);

    public void testSetValueInt() {
        ModifiableIntReference ref = this.buildIntReference(-3);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.setValue(4));
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
    }

    public void testAbs() {
        ModifiableIntReference ref = this.buildIntReference(-3);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.abs());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ref.setValue(3);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.abs());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
    }

    public void testNegate() {
        ModifiableIntReference ref = this.buildIntReference(-3);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.negate());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ref.setValue(3);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.negate());
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
    }

    public void testNegateExact() {
        ModifiableIntReference ref = this.buildIntReference(-3);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.negateExact());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ref.setValue(3);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.negateExact());
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
    }

    public void testSetZero() {
        ModifiableIntReference ref = this.buildIntReference(-3);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.setZero());
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
    }

    public void testAddInt() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int value = ref.add(3);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)value);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        value = ref.add(-7);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)value);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
    }

    public void testAddExactInt() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int value = ref.addExact(3);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)value);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        value = ref.addExact(-7);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)value);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
    }

    public void testIncrement() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int value = ref.increment();
        ModifiableIntReferenceTests.assertEquals((int)1, (int)value);
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
    }

    public void testIncrementExact() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int value = ref.incrementExact();
        ModifiableIntReferenceTests.assertEquals((int)1, (int)value);
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
    }

    public void testSubtractInt() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int count = ref.subtract(3);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)count);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        count = ref.subtract(-7);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)count);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
    }

    public void testSubtractExactInt() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int count = ref.subtractExact(3);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)count);
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        count = ref.subtractExact(-7);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)count);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
    }

    public void testDecrement() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int count = ref.decrement();
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)count);
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.getValue());
    }

    public void testDecrementExact() {
        ModifiableIntReference ref = this.buildIntReference();
        ModifiableIntReferenceTests.assertEquals((int)0, (int)ref.getValue());
        int count = ref.decrementExact();
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)count);
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.getValue());
    }

    public void testHalve() {
        ModifiableIntReference ref = this.buildIntReference(44);
        ModifiableIntReferenceTests.assertEquals((int)44, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)22, (int)ref.halve());
        ModifiableIntReferenceTests.assertEquals((int)22, (int)ref.getValue());
    }

    public void testTwice() {
        ModifiableIntReference ref = this.buildIntReference(44);
        ModifiableIntReferenceTests.assertEquals((int)44, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)88, (int)ref.twice());
        ModifiableIntReferenceTests.assertEquals((int)88, (int)ref.getValue());
    }

    public void testTwiceExact() {
        ModifiableIntReference ref = this.buildIntReference(44);
        ModifiableIntReferenceTests.assertEquals((int)44, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)88, (int)ref.twiceExact());
        ModifiableIntReferenceTests.assertEquals((int)88, (int)ref.getValue());
    }

    public void testMultiplyInt() {
        ModifiableIntReference ref = this.buildIntReference(3);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)9, (int)ref.multiply(3));
        ModifiableIntReferenceTests.assertEquals((int)9, (int)ref.getValue());
    }

    public void testMultiplyExactInt() {
        ModifiableIntReference ref = this.buildIntReference(3);
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)9, (int)ref.multiplyExact(3));
        ModifiableIntReferenceTests.assertEquals((int)9, (int)ref.getValue());
    }

    public void testDivideInt() {
        ModifiableIntReference ref = this.buildIntReference(24);
        ModifiableIntReferenceTests.assertEquals((int)24, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)8, (int)ref.divide(3));
        ModifiableIntReferenceTests.assertEquals((int)8, (int)ref.getValue());
        ref = this.buildIntReference(4);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.divide(3));
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
        ref = this.buildIntReference(-4);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.divide(3));
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.getValue());
    }

    public void testFloorDivideInt() {
        ModifiableIntReference ref = this.buildIntReference(24);
        ModifiableIntReferenceTests.assertEquals((int)24, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)8, (int)ref.floorDivide(3));
        ModifiableIntReferenceTests.assertEquals((int)8, (int)ref.getValue());
        ref = this.buildIntReference(4);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.floorDivide(3));
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
        ref = this.buildIntReference(-4);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-2, (int)ref.floorDivide(3));
        ModifiableIntReferenceTests.assertEquals((int)-2, (int)ref.getValue());
    }

    public void testRemainderInt() {
        ModifiableIntReference ref = this.buildIntReference(25);
        ModifiableIntReferenceTests.assertEquals((int)25, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.remainder(3));
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
        ref = this.buildIntReference(4);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.remainder(3));
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
        ref = this.buildIntReference(4);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.remainder(-3));
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
        ref = this.buildIntReference(-4);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.remainder(3));
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.getValue());
        ref = this.buildIntReference(-4);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.remainder(-3));
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.getValue());
    }

    public void testFloorRemainderInt() {
        ModifiableIntReference ref = this.buildIntReference(25);
        ModifiableIntReferenceTests.assertEquals((int)25, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.floorRemainder(3));
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
        ref = this.buildIntReference(4);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.floorRemainder(3));
        ModifiableIntReferenceTests.assertEquals((int)1, (int)ref.getValue());
        ref = this.buildIntReference(4);
        ModifiableIntReferenceTests.assertEquals((int)4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-2, (int)ref.floorRemainder(-3));
        ModifiableIntReferenceTests.assertEquals((int)-2, (int)ref.getValue());
        ref = this.buildIntReference(-4);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)2, (int)ref.floorRemainder(3));
        ModifiableIntReferenceTests.assertEquals((int)2, (int)ref.getValue());
        ref = this.buildIntReference(-4);
        ModifiableIntReferenceTests.assertEquals((int)-4, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.floorRemainder(-3));
        ModifiableIntReferenceTests.assertEquals((int)-1, (int)ref.getValue());
    }

    public void testMinInt() {
        ModifiableIntReference ref = this.buildIntReference(25);
        ModifiableIntReferenceTests.assertEquals((int)25, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.min(3));
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.min(33));
        ModifiableIntReferenceTests.assertEquals((int)3, (int)ref.getValue());
    }

    public void testMaxInt() {
        ModifiableIntReference ref = this.buildIntReference(25);
        ModifiableIntReferenceTests.assertEquals((int)25, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)25, (int)ref.max(3));
        ModifiableIntReferenceTests.assertEquals((int)25, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)30, (int)ref.max(30));
        ModifiableIntReferenceTests.assertEquals((int)30, (int)ref.getValue());
        ModifiableIntReferenceTests.assertEquals((int)30, (int)ref.max(3));
        ModifiableIntReferenceTests.assertEquals((int)30, (int)ref.getValue());
    }

    public void testCommitIntInt() {
        ModifiableIntReference ref = this.buildIntReference(25);
        ModifiableIntReferenceTests.assertTrue((boolean)ref.commit(-3, 25));
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
        ModifiableIntReferenceTests.assertFalse((boolean)ref.commit(22, 25));
        ModifiableIntReferenceTests.assertEquals((int)-3, (int)ref.getValue());
    }

    public void testSwapRef() throws Exception {
        ModifiableIntReference ref1;
        ModifiableIntReference ref2 = ref1 = this.buildIntReference(33);
        ModifiableIntReferenceTests.assertEquals((int)33, (int)ref1.swap(ref2));
        ref2 = this.buildIntReference(-7);
        ModifiableIntReferenceTests.assertEquals((int)-7, (int)ref1.swap(ref2));
        ModifiableIntReferenceTests.assertEquals((int)-7, (int)ref1.getValue());
        ModifiableIntReferenceTests.assertEquals((int)33, (int)ref2.getValue());
        ref1.setValue(42);
        ref2.setValue(42);
        ModifiableIntReferenceTests.assertEquals((int)42, (int)ref1.swap(ref2));
        ModifiableIntReferenceTests.assertEquals((int)42, (int)ref1.getValue());
        ModifiableIntReferenceTests.assertEquals((int)42, (int)ref2.getValue());
    }
}

