/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotation.internal.model;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.ejb.annotation.internal.messages.IEJBAnnotationConstants;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IEnterpriseBeanClassDataModelProperties;
import org.eclipse.jst.j2ee.ejb.annotation.internal.utility.AnnotationUtilities;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class EnterpriseBeanClassDataModelProvider
extends NewJavaClassDataModelProvider
implements IEnterpriseBeanClassDataModelProperties {
    protected abstract void initializeDelegate();

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IAnnotationsDataModel.useAnnotations");
        propertyNames.add("IEjbCommonDataModel.EJB_TYPE");
        propertyNames.add("IEjbCommonDataModel.EJB_NAME");
        propertyNames.add("IEjbCommonDataModel.DISPLAY_NAME");
        propertyNames.add("IEjbCommonDataModel.JNDI_NAME");
        propertyNames.add("IEjbCommonDataModel.DESCRIPTION");
        propertyNames.add("NewJavaClassDataModel.CLASS_NAME");
        propertyNames.add("IEjbCommonDataModel.TRANSACTIONTYPE");
        propertyNames.add("IEjbCommonDataModel.ANNOTATIONPROVIDER");
        propertyNames.add("IEjbCommonDataModel.MODELDELEGATE");
        propertyNames.add("IEjbCommonDataModel.INTERFACES_AS_STRING");
        return propertyNames;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if ("IAnnotationsDataModel.useAnnotations".equals(propertyName)) {
            return true;
        }
        return super.isPropertyEnabled(propertyName);
    }

    protected boolean isAnnotationsSupported() {
        if (this.getTargetProject() == null || this.getTargetComponent() == null) {
            return true;
        }
        EJBArtifactEdit ejbEdit = null;
        try {
            ejbEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.getTargetProject());
            if (ejbEdit == null) {
                return false;
            }
            boolean bl = ejbEdit.getJ2EEVersion() > 12;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (ejbEdit != null) {
                ejbEdit.dispose();
            }
        }
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) {
            this.getDataModel().notifyPropertyChange("IAnnotationsDataModel.useAnnotations", 3);
        } else if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            if (!this.isPropertySet("IEjbCommonDataModel.EJB_NAME")) {
                this.getDataModel().notifyPropertyChange("IEjbCommonDataModel.EJB_NAME", 2);
            }
        } else if (propertyName.equals("IEjbCommonDataModel.EJB_NAME")) {
            if (!this.isPropertySet("IEjbCommonDataModel.JNDI_NAME")) {
                this.getDataModel().notifyPropertyChange("IEjbCommonDataModel.JNDI_NAME", 2);
            }
            if (!this.isPropertySet("IEjbCommonDataModel.DISPLAY_NAME")) {
                this.getDataModel().notifyPropertyChange("IEjbCommonDataModel.DISPLAY_NAME", 2);
            }
            if (!this.isPropertySet("IEjbCommonDataModel.DESCRIPTION")) {
                this.getDataModel().notifyPropertyChange("IEjbCommonDataModel.DESCRIPTION", 2);
            }
        }
        return result;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IAnnotationsDataModel.useAnnotations")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            return "MyBean";
        }
        if (propertyName.equals("IEjbCommonDataModel.EJB_NAME")) {
            String className = this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
            if (className.endsWith("Bean")) {
                className = className.substring(0, className.length() - 4);
            }
            return className;
        }
        if (propertyName.equals("IEjbCommonDataModel.JNDI_NAME")) {
            return this.getProperty("IEjbCommonDataModel.EJB_NAME");
        }
        if (propertyName.equals("IEjbCommonDataModel.TRANSACTIONTYPE")) {
            return TransactionType.CONTAINER_LITERAL.getName();
        }
        if (propertyName.equals("IEjbCommonDataModel.EJB_TYPE")) {
            return "SessionBean";
        }
        if (propertyName.equals("IEjbCommonDataModel.DISPLAY_NAME")) {
            return this.getProperty("IEjbCommonDataModel.EJB_NAME");
        }
        if (propertyName.equals("IEjbCommonDataModel.DESCRIPTION")) {
            return "An EJB named " + this.getStringProperty("IEjbCommonDataModel.EJB_NAME");
        }
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
            return this.getEJBInterfaces();
        }
        if (propertyName.equals("IEjbCommonDataModel.ANNOTATIONPROVIDER")) {
            String[] providers = AnnotationUtilities.getProviderNames();
            if (providers != null && providers.length > 0) {
                return providers[0];
            }
        } else {
            if (propertyName.equals("NewJavaClassDataModel.SOURCE_FOLDER")) {
                try {
                    Object srcFolder = super.getDefaultProperty(propertyName);
                    return srcFolder;
                }
                catch (Exception exception) {
                    return "";
                }
            }
            if (propertyName.equals("IEjbCommonDataModel.INTERFACES_AS_STRING")) {
                return this.getInterfacesString();
            }
            if (propertyName.equals("IEjbCommonDataModel.MODELDELEGATE")) {
                this.initializeDelegate();
                return this.getProperty("IEjbCommonDataModel.MODELDELEGATE");
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            return this.validateEjbJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEjbCommonDataModel.EJB_NAME")) {
            return this.validateEJBName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEjbCommonDataModel.EJB_TYPE")) {
            return this.validateEJBType(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEjbCommonDataModel.JNDI_NAME")) {
            return this.validateJndiName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEjbCommonDataModel.DISPLAY_NAME")) {
            return this.validateDisplayName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.CLASS_NAME")) {
            return this.validateClassName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEjbCommonDataModel.TRANSACTIONTYPE")) {
            return this.validateTransaction(this.getStringProperty(propertyName));
        }
        return super.validate(propertyName);
    }

    protected IStatus validateClassName(String className) {
        IStatus status = this.validateJavaClassName(className);
        if (status.isOK()) {
            status = this.canCreateTypeInClasspath(className);
        }
        if (status != WTPCommonPlugin.OK_STATUS) {
            return status;
        }
        if (!className.equals("Bean") && !className.equals("EJB") && (className.endsWith("Bean") || className.endsWith("EJB"))) {
            return status;
        }
        String msg = IEJBAnnotationConstants.ERR_CLASS_NAME_MUSTEND_WITH_BEAN;
        return WTPCommonPlugin.createErrorStatus((String)msg);
    }

    protected IStatus validateEjbJavaPackage(String packageName) {
        if (packageName != null && packageName.trim().length() > 0) {
            IStatus javaStatus = JavaConventions.validatePackageName((String)packageName);
            if (javaStatus.getSeverity() == 4) {
                String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            if (javaStatus.getSeverity() == 2) {
                String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        if (packageName == null || packageName.trim().length() == 0) {
            String msg = IEJBAnnotationConstants.ERR_MUST_ENTER_A_PACKAGE_NAME;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateEJBType(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = IEJBAnnotationConstants.ERR_EJB_TYPE_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (prop.indexOf("SessionBean") >= 0 || prop.indexOf("MessageDrivenBean") >= 0 || prop.indexOf("EntityBean") >= 0) {
            return WTPCommonPlugin.OK_STATUS;
        }
        String msg = IEJBAnnotationConstants.ERR_EJB_TYPE_VALUE;
        return WTPCommonPlugin.createErrorStatus((String)msg);
    }

    private IStatus validateTransaction(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = IEJBAnnotationConstants.ERR_TRANSACTION_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (prop.indexOf("Container") >= 0 || prop.indexOf("Bean") >= 0) {
            return WTPCommonPlugin.OK_STATUS;
        }
        String msg = IEJBAnnotationConstants.ERR_TRANSACTION_VALUE;
        return WTPCommonPlugin.createErrorStatus((String)msg);
    }

    protected IStatus validateJndiName(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = IEJBAnnotationConstants.ERR_JNDI_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (prop.indexOf(" ") >= 0) {
            String msg = IEJBAnnotationConstants.ERR_JNDI_NAME_VALUE;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateEJBName(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = IEJBAnnotationConstants.ERR_EJB_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (prop.indexOf("Bean") >= 0) {
            String msg = IEJBAnnotationConstants.ERR_EJB_NAME_ENDS_WITH_BEAN;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected IStatus validateDisplayName(String prop) {
        block15: {
            if (prop == null || prop.trim().length() == 0) {
                String msg = IEJBAnnotationConstants.ERR_DISPLAY_NAME_EMPTY;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            if (this.getTargetProject() == null) {
                return WTPCommonPlugin.OK_STATUS;
            }
            ArtifactEdit edit = null;
            try {
                edit = ArtifactEdit.getArtifactEditForRead((IProject)this.getTargetProject());
                if (edit == null) {
                    IStatus iStatus = WTPCommonPlugin.OK_STATUS;
                    return iStatus;
                }
                EJBJar ejbJar = (EJBJar)edit.getContentModelRoot();
                if (ejbJar == null) {
                    IStatus iStatus = WTPCommonPlugin.OK_STATUS;
                    return iStatus;
                }
                EList ejbs = ejbJar.getEnterpriseBeans();
                if (ejbs == null || ejbs.size() <= 0) break block15;
                int i = 0;
                while (i < ejbs.size()) {
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
                    if (prop.equals(ejb.getDisplayName())) {
                        String msg = IEJBAnnotationConstants.ERR_EJB_DISPLAY_NAME_USED;
                        IStatus iStatus = WTPCommonPlugin.createErrorStatus((String)msg);
                        return iStatus;
                    }
                    try {
                        ++i;
                        continue;
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected IStatus validateJavaClassName(String prop) {
        IStatus status = super.validateJavaClassName(prop);
        if (status == WTPCommonPlugin.OK_STATUS && this.getTargetProject() != null) {
            try {
                IJavaProject jProject = JavaCore.create((IProject)this.getTargetProject());
                String pName = this.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
                IType type = jProject.findType(String.valueOf(pName) + "." + prop);
                if (type != null) {
                    String msg = IEJBAnnotationConstants.ERR_EJB_TYPE_EXISTS;
                    return WTPCommonPlugin.createErrorStatus((String)msg);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return status;
    }

    protected String getInterfacesString() {
        List ints = (List)this.getProperty("NewJavaClassDataModel.INTERFACES");
        Iterator iterator = ints.iterator();
        String intStr = iterator.hasNext() ? (String)iterator.next() : this.getDefaultInterfaces();
        while (iterator.hasNext()) {
            String intrfc = (String)iterator.next();
            intStr = String.valueOf(intStr) + ", " + intrfc;
        }
        return intStr;
    }

    private String getDefaultInterfaces() {
        Iterator interfaces = this.getEJBInterfaces().iterator();
        String interfacesStr = interfaces.hasNext() ? (String)interfaces.next() : "";
        while (interfaces.hasNext()) {
            interfacesStr = String.valueOf(interfacesStr) + ", " + (String)interfaces.next();
        }
        return interfacesStr;
    }

    protected abstract List getEJBInterfaces();
}

