/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation.timely;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IDeltaBag;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FaithfulTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.communication.timely.ResumableNode;

public class FaithfulSequentialTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends FaithfulTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult, CumulativeAggregate<Domain, Accumulator, AggregateResult>, FoldingState<Domain, AggregateResult>>
implements ResumableNode {
    protected boolean isRecursiveAggregation = false;

    public FaithfulSequentialTimelyColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer, operator, groupMask, columnMask);
    }

    @Override
    public void networkStructureChanged() {
        super.networkStructureChanged();
        this.isRecursiveAggregation = this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this);
    }

    @Override
    protected Map<AggregateResult, Diff<Timestamp>> doFoldingStep(Tuple group, FoldingState<Domain, AggregateResult> state, Timestamp timestamp) {
        Object aggregate = this.getAggregate(group, timestamp);
        if (state.delta.isEmpty() && Objects.equals(state.oldResult, state.newResult)) {
            this.gcAggregates((CumulativeAggregate<Domain, Accumulator, AggregateResult>)aggregate, group, timestamp);
            return Collections.emptyMap();
        }
        Map diffMap = CollectionsFactory.createMap();
        Timestamp nextTimestamp = ((TreeMap)this.aggregates.get(group)).higherKey(timestamp);
        Object previousOldResult = state.oldResult;
        Object previousNewResult = state.newResult;
        Object currentOldResult = previousOldResult == null ? this.operator.getAggregate(((CumulativeAggregate)aggregate).positive) : this.operator.combine(previousOldResult, ((CumulativeAggregate)aggregate).positive);
        for (Map.Entry entry : state.delta.entriesWithMultiplicities()) {
            boolean contains;
            int i;
            boolean isInsertion = (Integer)entry.getValue() > 0;
            Object aggregand = entry.getKey();
            if (isInsertion) {
                i = 0;
                while (i < (Integer)entry.getValue()) {
                    if (this.isRecursiveAggregation) {
                        contains = ((CumulativeAggregate)aggregate).negative.containsNonZero(aggregand);
                        if (contains) {
                            ((CumulativeAggregate)aggregate).negative.addOne(aggregand);
                        } else {
                            ((CumulativeAggregate)aggregate).positive = this.operator.update(((CumulativeAggregate)aggregate).positive, aggregand, true);
                        }
                    } else {
                        ((CumulativeAggregate)aggregate).positive = this.operator.update(((CumulativeAggregate)aggregate).positive, aggregand, true);
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < -((Integer)entry.getValue()).intValue()) {
                if (this.isRecursiveAggregation) {
                    contains = this.operator.contains(aggregand, ((CumulativeAggregate)aggregate).positive);
                    if (contains) {
                        ((CumulativeAggregate)aggregate).positive = this.operator.update(((CumulativeAggregate)aggregate).positive, aggregand, false);
                    } else {
                        ((CumulativeAggregate)aggregate).negative.removeOne(aggregand);
                    }
                } else {
                    ((CumulativeAggregate)aggregate).positive = this.operator.update(((CumulativeAggregate)aggregate).positive, aggregand, false);
                }
                ++i;
            }
        }
        Object currentNewResult = previousNewResult == null ? this.operator.getAggregate(((CumulativeAggregate)aggregate).positive) : this.operator.combine(previousNewResult, ((CumulativeAggregate)aggregate).positive);
        ((CumulativeAggregate)aggregate).cachedResult = currentNewResult;
        boolean sameResult = Objects.equals(currentOldResult, currentNewResult);
        if (!sameResult) {
            FaithfulSequentialTimelyColumnAggregatorNode.appendDiff(currentOldResult, (Signed<Timestamp>)new Signed(Direction.DELETE, (Comparable)timestamp), diffMap);
            if (nextTimestamp != null) {
                FaithfulSequentialTimelyColumnAggregatorNode.appendDiff(currentOldResult, (Signed<Timestamp>)new Signed(Direction.INSERT, (Comparable)nextTimestamp), diffMap);
            }
            FaithfulSequentialTimelyColumnAggregatorNode.appendDiff(currentNewResult, (Signed<Timestamp>)new Signed(Direction.INSERT, (Comparable)timestamp), diffMap);
            if (nextTimestamp != null) {
                FaithfulSequentialTimelyColumnAggregatorNode.appendDiff(currentNewResult, (Signed<Timestamp>)new Signed(Direction.DELETE, (Comparable)nextTimestamp), diffMap);
            }
        }
        this.gcAggregates((CumulativeAggregate<Domain, Accumulator, AggregateResult>)aggregate, group, timestamp);
        this.updateTimeline(group, diffMap);
        if (nextTimestamp != null && !sameResult) {
            FoldingState newState = new FoldingState();
            newState.oldResult = currentOldResult;
            newState.newResult = currentNewResult;
            this.addFoldingState(group, newState, nextTimestamp);
        }
        return diffMap;
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        Tuple group = this.groupMask.transform((ITuple)update);
        Tuple value = this.columnMask.transform((ITuple)update);
        Object aggregand = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        AggregateResult previousResult = this.getResultRaw(group, timestamp, true);
        FoldingState state = new FoldingState();
        if (isInsertion) {
            state.delta.addOne(aggregand);
        } else {
            state.delta.removeOne(aggregand);
        }
        state.oldResult = previousResult;
        state.newResult = previousResult;
        this.addFoldingState(group, state, timestamp);
    }

    protected AggregateResult getResultRaw(Tuple group, Timestamp timestamp, boolean lower) {
        TreeMap entryMap = (TreeMap)this.aggregates.get(group);
        if (entryMap == null) {
            return null;
        }
        CumulativeAggregate aggregate = null;
        if (lower) {
            Map.Entry lowerEntry = entryMap.lowerEntry(timestamp);
            if (lowerEntry != null) {
                aggregate = (CumulativeAggregate)lowerEntry.getValue();
            }
        } else {
            aggregate = (CumulativeAggregate)entryMap.get(timestamp);
        }
        if (aggregate == null) {
            return null;
        }
        return aggregate.cachedResult;
    }

    @Override
    protected void gcAggregates(CumulativeAggregate<Domain, Accumulator, AggregateResult> aggregate, Tuple group, Timestamp timestamp) {
        if (this.operator.isNeutral(aggregate.positive) && aggregate.negative.isEmpty()) {
            TreeMap groupAggregates = (TreeMap)this.aggregates.get(group);
            groupAggregates.remove(timestamp);
            if (groupAggregates.isEmpty()) {
                this.aggregates.remove(group);
            }
        }
    }

    @Override
    protected CumulativeAggregate<Domain, Accumulator, AggregateResult> getAggregate(Tuple group, Timestamp timestamp) {
        TreeMap groupAggregates = this.aggregates.computeIfAbsent(group, k -> CollectionsFactory.createTreeMap());
        return groupAggregates.computeIfAbsent(timestamp, k -> {
            CumulativeAggregate aggregate = new CumulativeAggregate();
            aggregate.positive = this.operator.createNeutral();
            return aggregate;
        });
    }

    @Override
    public AggregateResult getAggregateResult(Tuple group) {
        TreeMap groupAggregates = (TreeMap)this.aggregates.get(group);
        if (groupAggregates != null) {
            Map.Entry lastEntry = groupAggregates.lastEntry();
            return ((CumulativeAggregate)lastEntry.getValue()).cachedResult;
        }
        return (AggregateResult)this.NEUTRAL;
    }

    protected static class CumulativeAggregate<Domain, Accumulator, AggregateResult> {
        protected Accumulator positive;
        protected IDeltaBag<Domain> negative = CollectionsFactory.createDeltaBag();
        protected AggregateResult cachedResult;

        protected CumulativeAggregate() {
        }

        public String toString() {
            return "positive=" + String.valueOf(this.positive) + " negative=" + String.valueOf(this.negative) + " cachedResult=" + String.valueOf(this.cachedResult);
        }
    }

    protected static class FoldingState<Domain, AggregateResult>
    implements FaithfulTimelyColumnAggregatorNode.MergeableFoldingState<FoldingState<Domain, AggregateResult>> {
        protected IDeltaBag<Domain> delta = CollectionsFactory.createDeltaBag();
        protected AggregateResult oldResult;
        protected AggregateResult newResult;

        protected FoldingState() {
        }

        public String toString() {
            return "delta=" + String.valueOf(this.delta) + " oldResult=" + String.valueOf(this.oldResult) + " newResult=" + String.valueOf(this.newResult);
        }

        @Override
        public FoldingState<Domain, AggregateResult> merge(FoldingState<Domain, AggregateResult> that) {
            Preconditions.checkArgument((that != null ? 1 : 0) != 0);
            FoldingState<Domain, AggregateResult> result = new FoldingState<Domain, AggregateResult>();
            this.delta.forEachEntryWithMultiplicities((d, m) -> {
                boolean bl = foldingState.delta.addSigned(d, m.intValue());
            });
            that.delta.forEachEntryWithMultiplicities((d, m) -> {
                boolean bl = foldingState.delta.addSigned(d, m.intValue());
            });
            result.oldResult = this.oldResult;
            result.newResult = that.newResult;
            return result;
        }
    }
}

