/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.viatra.query.runtime.api.scope.IBaseIndex;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class MatchParameterPropertyDescriptor
implements IPropertyDescriptor {
    private String category = "Filters";
    private final PParameter parameter;
    private final QueryResultTreeMatcher<?> matcher;
    private final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    private final AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator(this.adapterFactory);
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(this.adapterFactory);
    private final LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            return MatchParameterPropertyDescriptor.this.adapterFactoryItemDelegator.getText(element);
        }

        public Image getImage(Object element) {
            return ExtendedImageRegistry.INSTANCE.getImage(MatchParameterPropertyDescriptor.this.adapterFactoryItemDelegator.getImage(element));
        }
    };

    public CellEditor createPropertyEditor(Composite parent) {
        IInputKey typeKey = this.parameter.getDeclaredUnaryType();
        if (typeKey != null) {
            CellEditor result = this.prepareEditorForDeclaredType(parent, typeKey);
            return result;
        }
        return this.prepareEditorForUnknownType(parent);
    }

    protected CellEditor prepareEditorForDeclaredType(Composite parent, IInputKey typeKey) {
        List<Boolean> _asList;
        ExtendedComboBoxCellEditor _xblockexpression;
        ExtendedComboBoxCellEditor _switchResult = null;
        boolean _matched = false;
        if (typeKey instanceof JavaTransitiveInstancesKey) {
            _matched = true;
            return this.prepareEditorForUnknownType(parent);
        }
        if (!_matched && typeKey instanceof EClassTransitiveInstancesKey) {
            _matched = true;
            _xblockexpression = null;
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)typeKey).getEmfKey();
            ArrayList<EObject> choiceOfValues = this.getChoiceOfValues(eClass);
            ArrayList<EObject> _arrayList = new ArrayList<EObject>(choiceOfValues);
            _switchResult = _xblockexpression = new ExtendedComboBoxCellEditor(parent, _arrayList, (ILabelProvider)this.labelProvider, true);
        }
        if (!_matched && typeKey instanceof EDataTypeInSlotsKey) {
            _matched = true;
            _xblockexpression = null;
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)typeKey).getEmfKey();
            PropertyDescriptor.EDataTypeCellEditor _xifexpression = null;
            if (dataType instanceof EEnum) {
                ExtendedComboBoxCellEditor _xblockexpression_1 = null;
                Functions.Function1 _function = it -> it.getInstance();
                List choiceOfValues = ListExtensions.map((List)((EEnum)dataType).getELiterals(), (Functions.Function1)_function);
                ArrayList _arrayList = new ArrayList(choiceOfValues);
                _xblockexpression_1 = new ExtendedComboBoxCellEditor(parent, _arrayList, (ILabelProvider)this.labelProvider, false);
                _xifexpression = _xblockexpression_1;
            } else {
                PropertyDescriptor.EDataTypeCellEditor _xifexpression_1 = null;
                if (Objects.equals(dataType.getInstanceClass(), Boolean.class) || Objects.equals(dataType.getInstanceClass(), Boolean.TYPE)) {
                    _asList = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
                    _xifexpression_1 = new ExtendedComboBoxCellEditor(parent, _asList, (ILabelProvider)this.labelProvider, true);
                } else {
                    _xifexpression_1 = new PropertyDescriptor.EDataTypeCellEditor(dataType, parent);
                }
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched) {
            String _name;
            ExtendedComboBoxCellEditor _xifexpression = null;
            String _typeName = this.parameter.getTypeName();
            boolean _equals = Objects.equals(_typeName, _name = Boolean.class.getName());
            if (_equals) {
                _asList = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
                _xifexpression = new ExtendedComboBoxCellEditor(parent, _asList, (ILabelProvider)this.labelProvider, true);
            } else {
                _xifexpression = null;
            }
            _switchResult = _xifexpression;
        }
        ExtendedComboBoxCellEditor result = _switchResult;
        return result;
    }

    protected ExtendedComboBoxCellEditor prepareEditorForUnknownType(Composite parent) {
        Set choiceOfValues = this.matcher.getMatcher().getAllValues(this.parameter.getName());
        ArrayList _arrayList = new ArrayList(choiceOfValues);
        ExtendedComboBoxCellEditor editor = new ExtendedComboBoxCellEditor(parent, _arrayList, (ILabelProvider)this.labelProvider, false);
        return editor;
    }

    protected ArrayList<EObject> getChoiceOfValues(EClass eClass) {
        ArrayList choiceOfValues = CollectionLiterals.newArrayList();
        IBaseIndex _baseIndex = this.matcher.getMatcher().getEngine().getBaseIndex();
        EMFBaseIndexWrapper emfBaseIndex = (EMFBaseIndexWrapper)_baseIndex;
        NavigationHelper navigationHelper = emfBaseIndex.getNavigationHelper();
        if (navigationHelper.isInWildcardMode() || Objects.equals(navigationHelper.getIndexingLevel(eClass), IndexingLevel.FULL)) {
            Set allInstances = navigationHelper.getAllInstances(eClass);
            Iterables.addAll((Collection)choiceOfValues, (Iterable)allInstances);
        } else {
            Iterable _filter = Iterables.filter((Iterable)this.matcher.getMatcher().getAllValues(this.parameter.getName()), EObject.class);
            Iterables.addAll((Collection)choiceOfValues, (Iterable)_filter);
        }
        return choiceOfValues;
    }

    protected ArrayList<Object> getChoiceOfValues(EDataType eDataType) {
        ArrayList choiceOfValues = CollectionLiterals.newArrayList();
        IBaseIndex _baseIndex = this.matcher.getMatcher().getEngine().getBaseIndex();
        EMFBaseIndexWrapper emfBaseIndex = (EMFBaseIndexWrapper)_baseIndex;
        NavigationHelper navigationHelper = emfBaseIndex.getNavigationHelper();
        if (navigationHelper.isInWildcardMode() || Objects.equals(navigationHelper.getIndexingLevel(eDataType), IndexingLevel.FULL)) {
            Set allInstances = navigationHelper.getDataTypeInstances(eDataType);
            Iterables.addAll((Collection)choiceOfValues, (Iterable)allInstances);
        } else {
            Set _allValues = this.matcher.getMatcher().getAllValues(this.parameter.getName());
            Iterables.addAll((Collection)choiceOfValues, (Iterable)_allValues);
        }
        return choiceOfValues;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Filter for parameter ");
        String _name = this.parameter.getName();
        _builder.append(_name);
        _builder.append(" with type ");
        IInputKey _declaredUnaryType = this.parameter.getDeclaredUnaryType();
        _builder.append((Object)_declaredUnaryType);
        return _builder.toString();
    }

    public String getDisplayName() {
        return this.parameter.getName();
    }

    public String[] getFilterFlags() {
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return this.parameter;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }

    public MatchParameterPropertyDescriptor(PParameter parameter, QueryResultTreeMatcher<?> matcher) {
        this.parameter = parameter;
        this.matcher = matcher;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Pure
    public PParameter getParameter() {
        return this.parameter;
    }

    @Pure
    public QueryResultTreeMatcher<?> getMatcher() {
        return this.matcher;
    }

    @Pure
    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Pure
    public AdapterFactoryItemDelegator getAdapterFactoryItemDelegator() {
        return this.adapterFactoryItemDelegator;
    }

    @Pure
    public AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        return this.adapterFactoryLabelProvider;
    }
}

