/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.viatra.dse.api.SolutionTrajectory;

public class Solution {
    private Set<SolutionTrajectory> trajectories;
    private final Object stateId;

    public Solution(Object stateId, SolutionTrajectory trajectory) {
        this.stateId = stateId;
        this.trajectories = new HashSet<SolutionTrajectory>();
        this.trajectories.add(trajectory);
    }

    public void addTrajectory(SolutionTrajectory trajectory) {
        this.trajectories.add(trajectory);
    }

    public SolutionTrajectory getArbitraryTrajectory() {
        return this.trajectories.iterator().next();
    }

    public SolutionTrajectory getShortestTrajectory() {
        Iterator<SolutionTrajectory> iterator = this.trajectories.iterator();
        SolutionTrajectory shortestTrajecotry = iterator.next();
        int minSize = shortestTrajecotry.getTrajectoryLength();
        while (iterator.hasNext()) {
            SolutionTrajectory traj = iterator.next();
            int size = traj.getTrajectoryLength();
            if (size >= minSize) continue;
            shortestTrajecotry = traj;
            minSize = size;
        }
        return shortestTrajecotry;
    }

    public Collection<SolutionTrajectory> getTrajectories() {
        return this.trajectories;
    }

    public Object getStateCode() {
        return this.stateId;
    }
}

