/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.scopes.tables;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.AbstractIndexTable;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableContext;
import org.eclipse.viatra.query.runtime.matchers.scopes.tables.ITableWriterUnary;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.IMemory;

public class SimpleUnaryTable<Value>
extends AbstractIndexTable
implements ITableWriterUnary.Table<Value> {
    protected IMemory<Value> values = CollectionsFactory.createMultiset();
    private boolean unique;

    public SimpleUnaryTable(IInputKey inputKey, ITableContext tableContext, boolean unique) {
        super(inputKey, tableContext);
        this.unique = unique;
        if (1 != inputKey.getArity()) {
            throw new IllegalArgumentException(inputKey.toString());
        }
    }

    @Override
    public void write(Direction direction, Value value) {
        if (direction == Direction.INSERT) {
            boolean changed = this.values.addOne(value);
            if (this.unique && !changed) {
                String msg = String.format("Error: trying to add duplicate value %s to the unique set %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName());
                this.logError(msg);
            }
            if (changed && this.emitNotifications) {
                this.deliverChangeNotifications(Tuples.staticArityFlatTupleOf(value), true);
            }
        } else {
            boolean changed = this.values.removeOne(value);
            if (this.unique && !changed) {
                String msg = String.format("Error: trying to remove duplicate value %s from the unique set %s. This indicates some errors in underlying model representation.", value, this.getInputKey().getPrettyPrintableName());
                this.logError(msg);
            }
            if (changed && this.emitNotifications) {
                this.deliverChangeNotifications(Tuples.staticArityFlatTupleOf(value), false);
            }
        }
    }

    @Override
    public boolean containsTuple(ITuple seed) {
        return this.values.containsNonZero(seed.get(0));
    }

    @Override
    public int countTuples(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() == 0) {
            return this.values.size();
        }
        Object value = seed.get(0);
        return this.values.containsNonZero(value) ? 1 : 0;
    }

    @Override
    public Optional<Long> estimateProjectionSize(TupleMask groupMask, Accuracy requiredAccuracy) {
        if (groupMask.getSize() == 0) {
            return this.values.isEmpty() ? Optional.of(0L) : Optional.of(1L);
        }
        return Optional.of(Long.valueOf(this.values.size()));
    }

    @Override
    public Stream<? extends Tuple> streamTuples(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() == 0) {
            return this.values.distinctValues().stream().map(Tuples::staticArityFlatTupleOf);
        }
        Object value = seed.get(0);
        if (this.values.containsNonZero(value)) {
            return Stream.of(Tuples.staticArityFlatTupleOf(value));
        }
        return Stream.empty();
    }

    @Override
    public Iterable<? extends Object> enumerateValues(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() == 0) {
            return this.values;
        }
        throw new IllegalArgumentException(seedMask.toString());
    }

    @Override
    public Stream<? extends Object> streamValues(TupleMask seedMask, ITuple seed) {
        if (seedMask.getSize() == 0) {
            return this.values.asStream();
        }
        throw new IllegalArgumentException(seedMask.toString());
    }
}

