/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.api.event.EventHandler;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.notification.ActivationNotificationProvider;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationListener;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationProvider;

public class RuleInstance<EventAtom>
implements IActivationNotificationProvider {
    private static final String UNMODIFIABLE_VIEW_MESSAGE = "Unmodifiable view";
    private final RuleSpecification<EventAtom> specification;
    private final Map<ActivationState, Map<EventAtom, Activation<EventAtom>>> activationsByState;
    private final Map<EventAtom, Map<ActivationState, Activation<EventAtom>>> activationsByEvent;
    private final ActivationNotificationProvider activationNotificationProvider;
    private EventHandler<EventAtom> handler;
    private final Set<Activation<EventAtom>> allActivationsLiveView = new Set<Activation<EventAtom>>(){

        @Override
        public int size() {
            return RuleInstance.this.activationsByState.entrySet().stream().mapToInt(entry -> ((Map)entry.getValue()).size()).sum();
        }

        @Override
        public boolean isEmpty() {
            return RuleInstance.this.activationsByState.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Activation) {
                Activation activation = (Activation)o;
                ActivationState state = activation.getState();
                Object atom = activation.getAtom();
                return RuleInstance.this.activationsByEvent.getOrDefault(atom, Collections.emptyMap()).containsKey(state);
            }
            return false;
        }

        @Override
        public Iterator<Activation<EventAtom>> iterator() {
            return RuleInstance.this.streamAllActivations().iterator();
        }

        @Override
        public Object[] toArray() {
            return RuleInstance.this.streamAllActivations().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return RuleInstance.this.streamAllActivations().collect(Collectors.toList()).toArray(a);
        }

        @Override
        public boolean add(Activation<EventAtom> e) {
            throw new UnsupportedOperationException(RuleInstance.UNMODIFIABLE_VIEW_MESSAGE);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException(RuleInstance.UNMODIFIABLE_VIEW_MESSAGE);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.stream().allMatch(this::contains);
        }

        @Override
        public boolean addAll(Collection<? extends Activation<EventAtom>> c) {
            throw new UnsupportedOperationException(RuleInstance.UNMODIFIABLE_VIEW_MESSAGE);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException(RuleInstance.UNMODIFIABLE_VIEW_MESSAGE);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException(RuleInstance.UNMODIFIABLE_VIEW_MESSAGE);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(RuleInstance.UNMODIFIABLE_VIEW_MESSAGE);
        }

        @Override
        public int hashCode() {
            return RuleInstance.this.streamAllActivations().mapToInt(Activation::hashCode).sum();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Set) {
                Set set = (Set)obj;
                return set.size() == this.size() && this.containsAll(set);
            }
            return false;
        }
    };

    protected RuleInstance(RuleSpecification<EventAtom> specification) {
        this.specification = Objects.requireNonNull(specification, "Cannot create rule instance for null specification!");
        this.activationsByState = CollectionsFactory.createMap();
        this.activationsByEvent = CollectionsFactory.createMap();
        this.activationNotificationProvider = new DefaultActivationNotificationProvider();
    }

    public void setHandler(EventHandler<EventAtom> handler) {
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (String)"Handler cannot be null!");
        Preconditions.checkState((this.handler == null || handler.equals(this.handler) ? 1 : 0) != 0, (String)"Handler already set!");
        this.handler = handler;
    }

    public Activation<EventAtom> createActivation(EventAtom atom) {
        return new Activation<EventAtom>(this, atom, this.getActivationInactiveState());
    }

    private ActivationState getActivationInactiveState() {
        return this.specification.getLifeCycle().getInactiveState();
    }

    public void fire(Activation<EventAtom> activation, Context context) {
        Objects.requireNonNull(activation, "Cannot fire null activation!");
        Objects.requireNonNull(context, "Cannot fire activation with null context");
        ActivationState activationState = activation.getState();
        EventAtom atom = activation.getAtom();
        this.doFire(activation, activationState, atom, context);
    }

    protected void doFire(Activation<EventAtom> activation, ActivationState activationState, EventAtom atom, Context context) {
        if (this.activationsByState.getOrDefault(activationState, Collections.emptyMap()).containsKey(atom)) {
            Collection jobs = Optional.ofNullable(this.specification.getJobs(activationState)).orElse(Collections.emptyList());
            this.activationStateTransition(activation, EventType.RuleEngineEventType.FIRE);
            for (Job job : jobs) {
                try {
                    job.execute(activation, context);
                }
                catch (Exception e) {
                    job.handleError(activation, e, context);
                }
            }
        }
    }

    public ActivationState activationStateTransition(Activation<EventAtom> activation, EventType event) {
        Objects.requireNonNull(activation, "Cannot perform state transition on null activation!");
        Objects.requireNonNull(event, "Cannot perform state transition with null event!");
        ActivationState activationState = activation.getState();
        ActivationState nextActivationState = this.specification.getLifeCycle().nextActivationState(activationState, event);
        EventAtom atom = activation.getAtom();
        if (nextActivationState != null) {
            Map byEvent = this.activationsByState.getOrDefault(activationState, Collections.emptyMap());
            Activation removed = (Activation)byEvent.remove(atom);
            if (removed != null && byEvent.isEmpty()) {
                this.activationsByState.remove(activationState);
            }
            this.activationsByEvent.computeIfPresent(atom, (k, map) -> {
                map.remove(activationState);
                return map.isEmpty() ? null : map;
            });
            activation.setState(nextActivationState);
            if (!nextActivationState.isInactive()) {
                this.activationsByState.computeIfAbsent(nextActivationState, k -> CollectionsFactory.createMap()).put(atom, activation);
                this.activationsByEvent.computeIfAbsent(atom, k -> CollectionsFactory.createMap()).put(nextActivationState, activation);
                if (removed == null) {
                    this.activationNotificationProvider.notifyActivationCreated(activation, activationState);
                } else {
                    this.activationNotificationProvider.notifyActivationChanged(activation, activationState, event);
                }
            } else {
                this.activationNotificationProvider.notifyActivationRemoved(activation, activationState);
            }
        } else {
            nextActivationState = activationState;
            this.activationNotificationProvider.notifyActivationChanged(activation, activationState, event);
        }
        return nextActivationState;
    }

    @Override
    public boolean addActivationNotificationListener(IActivationNotificationListener listener, boolean fireNow) {
        return this.activationNotificationProvider.addActivationNotificationListener(listener, fireNow);
    }

    @Override
    public boolean removeActivationNotificationListener(IActivationNotificationListener listener) {
        return this.activationNotificationProvider.removeActivationNotificationListener(listener);
    }

    public RuleSpecification<EventAtom> getSpecification() {
        return this.specification;
    }

    public EventFilter<? super EventAtom> getFilter() {
        Preconditions.checkState((this.handler != null ? 1 : 0) != 0, (String)"Cannot get filter, bacause handler is null!");
        return this.handler.getEventFilter();
    }

    public ActivationLifeCycle getLifeCycle() {
        return this.specification.getLifeCycle();
    }

    public Map<ActivationState, Activation<EventAtom>> getActivationsFor(EventAtom atom) {
        return this.activationsByEvent.getOrDefault(atom, Collections.emptyMap());
    }

    public Stream<Activation<EventAtom>> streamAllActivations() {
        return this.activationsByState.values().stream().flatMap(byEvent -> byEvent.values().stream());
    }

    public Set<Activation<EventAtom>> getAllActivations() {
        return this.allActivationsLiveView;
    }

    public Collection<Activation<EventAtom>> getActivationsFor(ActivationState state) {
        Objects.requireNonNull(state, "Cannot return activations for null state");
        return this.activationsByState.getOrDefault(state, Collections.emptyMap()).values();
    }

    protected void dispose() {
        this.handler.dispose();
        for (Map.Entry<ActivationState, Map<EventAtom, Activation<EventAtom>>> stateEntry : this.activationsByState.entrySet()) {
            for (Map.Entry<EventAtom, Activation<EventAtom>> eventEntry : stateEntry.getValue().entrySet()) {
                Activation<EventAtom> activation = eventEntry.getValue();
                ActivationState activationState = activation.getState();
                activation.setState(this.specification.getLifeCycle().getInactiveState());
                this.activationNotificationProvider.notifyActivationRemoved(activation, activationState);
            }
        }
        this.activationNotificationProvider.dispose();
    }

    public String toString() {
        return String.format("%s{spec=%s, activations=%s}", this.getClass().getName(), this.specification, this.activationsByState);
    }

    private final class DefaultActivationNotificationProvider
    extends ActivationNotificationProvider {
        private DefaultActivationNotificationProvider() {
        }

        @Override
        protected void listenerAdded(IActivationNotificationListener listener, boolean fireNow) {
            if (fireNow) {
                ActivationState inactiveState = RuleInstance.this.getActivationInactiveState();
                for (Activation activation : RuleInstance.this.getAllActivations()) {
                    listener.activationCreated(activation, inactiveState);
                }
            }
        }
    }
}

