/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;

public abstract class ASTAmbiguousCastVsFunctionCallExpression
extends ASTAmbiguousNode
implements IASTAmbiguousExpression {
    private final IASTCastExpression fCastExpression;
    private final IASTFunctionCallExpression fFunctionCallExpression;

    public ASTAmbiguousCastVsFunctionCallExpression(IASTCastExpression castExpression, IASTFunctionCallExpression functionCall) {
        this.fCastExpression = castExpression;
        this.fFunctionCallExpression = functionCall;
    }

    @Override
    public final IASTNode[] getNodes() {
        return this.getExpressions();
    }

    @Override
    public final IASTExpression copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final IASTExpression copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addExpression(IASTExpression e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTExpression[] getExpressions() {
        return new IASTExpression[]{this.fCastExpression, this.fFunctionCallExpression};
    }

    @Override
    protected final IASTNode doResolveAmbiguity(ASTVisitor visitor) {
        IASTExpression result;
        IASTExpression nodeToReplace;
        IASTAmbiguityParent owner;
        block16: {
            owner = (IASTAmbiguityParent)((Object)this.getParent());
            nodeToReplace = this;
            owner.replace(nodeToReplace, this.fCastExpression);
            nodeToReplace = this.fCastExpression;
            this.fCastExpression.accept(visitor);
            IASTUnaryExpression primaryWithParenthesis = this.findPrimaryExpressionInParenthesis(this.fCastExpression.getOperand());
            if (primaryWithParenthesis == null) {
                return nodeToReplace;
            }
            ASTAmbiguousNode.NameCollector nameCollector = new ASTAmbiguousNode.NameCollector();
            this.fCastExpression.getTypeId().accept(nameCollector);
            IASTName[] names = nameCollector.getNames();
            boolean hasIssue = false;
            IASTName[] iASTNameArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    IASTName name = iASTNameArray[n2];
                    try {
                        IBinding b = name.resolveBinding();
                        if (b instanceof IProblemBinding) {
                            hasIssue = true;
                        }
                        break block15;
                    }
                    catch (Exception t) {
                        hasIssue = true;
                    }
                    break;
                }
                ++n2;
            }
            if (!hasIssue) {
                return nodeToReplace;
            }
            IASTExpression operand = primaryWithParenthesis.getOperand();
            if (operand instanceof IASTExpressionList) {
                IASTExpressionList list = (IASTExpressionList)operand;
                this.fFunctionCallExpression.setArguments(list.getExpressions());
            } else if (operand != null) {
                this.fFunctionCallExpression.setArguments(new IASTInitializerClause[]{operand});
            } else {
                this.fFunctionCallExpression.setArguments(IASTExpression.EMPTY_EXPRESSION_ARRAY);
            }
            this.setRange(this.fFunctionCallExpression, this.fCastExpression, primaryWithParenthesis);
            result = this.fFunctionCallExpression;
            IASTExpression postFix = this.fCastExpression.getOperand();
            if (postFix != primaryWithParenthesis) {
                IASTUnaryExpression ue;
                result = postFix;
                while (true) {
                    this.setStart(postFix, this.fFunctionCallExpression);
                    if (postFix instanceof IASTArraySubscriptExpression) {
                        IASTArraySubscriptExpression ase = (IASTArraySubscriptExpression)postFix;
                        if ((postFix = ase.getArrayExpression()) != primaryWithParenthesis) continue;
                        ase.setArrayExpression(this.fFunctionCallExpression);
                        break block16;
                    }
                    if (postFix instanceof IASTFunctionCallExpression) {
                        IASTFunctionCallExpression fc = (IASTFunctionCallExpression)postFix;
                        if ((postFix = fc.getFunctionNameExpression()) != primaryWithParenthesis) continue;
                        fc.setFunctionNameExpression(this.fFunctionCallExpression);
                        break block16;
                    }
                    if (postFix instanceof IASTFieldReference) {
                        IASTFieldReference fr = (IASTFieldReference)postFix;
                        if ((postFix = fr.getFieldOwner()) != primaryWithParenthesis) continue;
                        fr.setFieldOwner(this.fFunctionCallExpression);
                        break block16;
                    }
                    ue = (IASTUnaryExpression)postFix;
                    if ((postFix = ue.getOperand()) == primaryWithParenthesis) break;
                }
                ue.setOperand(this.fFunctionCallExpression);
            }
        }
        owner.replace(nodeToReplace, result);
        this.fFunctionCallExpression.getFunctionNameExpression().accept(visitor);
        return result;
    }

    private IASTUnaryExpression findPrimaryExpressionInParenthesis(IASTExpression operand) {
        block4: while (true) {
            if (operand instanceof IASTUnaryExpression) {
                IASTUnaryExpression unary = (IASTUnaryExpression)operand;
                switch (unary.getOperator()) {
                    case 11: {
                        return unary;
                    }
                    case 9: 
                    case 10: {
                        operand = unary.getOperand();
                        continue block4;
                    }
                }
                return null;
            }
            if (operand instanceof IASTArraySubscriptExpression) {
                operand = ((IASTArraySubscriptExpression)operand).getArrayExpression();
                continue;
            }
            if (operand instanceof IASTFunctionCallExpression) {
                operand = ((IASTFunctionCallExpression)operand).getFunctionNameExpression();
                continue;
            }
            if (!(operand instanceof IASTFieldReference)) break;
            operand = ((IASTFieldReference)operand).getFieldOwner();
        }
        return null;
    }

    private void setStart(IASTNode node, IASTNode start) {
        ASTNode target = (ASTNode)node;
        int offset = ((ASTNode)start).getOffset();
        target.setOffsetAndLength(offset, target.getOffset() + target.getLength() - offset);
    }

    private void setRange(IASTNode node, IASTNode from, IASTNode to) {
        int offset = ((ASTNode)from).getOffset();
        ASTNode t = (ASTNode)to;
        ((ASTNode)node).setOffsetAndLength(offset, t.getOffset() + t.getLength() - offset);
    }
}

