/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import java.net.URI;
import java.util.Collection;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.p2.ui.RepositoryOperationBeginningEvent;
import org.eclipse.equinox.internal.p2.ui.RepositoryOperationEndingEvent;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.UninstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateSingleIUWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.RepositoryManipulationPage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.BundleContext;

public class ProvisioningUI {
    private final Policy policy;
    private final ProvisioningSession session;
    private String profileId;
    private final ProvisioningOperationRunner runner;

    public static ProvisioningUI getDefaultUI() {
        return ProvUIActivator.getDefault().getProvisioningUI();
    }

    public ProvisioningUI(ProvisioningSession session, String profileId, Policy policy) {
        this.policy = policy;
        this.profileId = profileId;
        if (profileId == null) {
            this.profileId = "_SELF_";
        }
        this.session = session;
        this.runner = new ProvisioningOperationRunner(this);
        session.getProvisioningAgent().registerService(ProvisioningUI.class.getName(), (Object)this);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public ProvisioningSession getSession() {
        return this.session;
    }

    public LicenseManager getLicenseManager() {
        return (LicenseManager)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), LicenseManager.class);
    }

    public RepositoryTracker getRepositoryTracker() {
        return (RepositoryTracker)this.session.getProvisioningAgent().getService(RepositoryTracker.class);
    }

    public String getProfileId() {
        return this.profileId;
    }

    public InstallOperation getInstallOperation(Collection<IInstallableUnit> iusToInstall, URI[] repositories) {
        InstallOperation op = new InstallOperation(this.getSession(), iusToInstall);
        op.setProfileId(this.getProfileId());
        op.setProvisioningContext(this.makeProvisioningContext(repositories));
        return op;
    }

    public UpdateOperation getUpdateOperation(Collection<IInstallableUnit> iusToUpdate, URI[] repositories) {
        UpdateOperation op = new UpdateOperation(this.getSession(), iusToUpdate);
        op.setProfileId(this.getProfileId());
        op.setProvisioningContext(this.makeProvisioningContext(repositories));
        return op;
    }

    public UninstallOperation getUninstallOperation(Collection<IInstallableUnit> iusToUninstall, URI[] repositories) {
        UninstallOperation op = new UninstallOperation(this.getSession(), iusToUninstall);
        op.setProfileId(this.getProfileId());
        op.setProvisioningContext(this.makeProvisioningContext(repositories));
        return op;
    }

    private ProvisioningContext makeProvisioningContext(URI[] repos) {
        if (repos != null) {
            ProvisioningContext context = new ProvisioningContext(this.getSession().getProvisioningAgent());
            context.setMetadataRepositories(repos);
            context.setArtifactRepositories(repos);
            return context;
        }
        return new ProvisioningContext(this.getSession().getProvisioningAgent());
    }

    public int openInstallWizard(Collection<IInstallableUnit> initialSelections, InstallOperation operation, LoadMetadataRepositoryJob job) {
        return this.openInstallWizard(initialSelections, operation, null, job);
    }

    public int openInstallWizard(Collection<IInstallableUnit> initialSelections, InstallOperation operation, RemediationOperation remediationOperation, LoadMetadataRepositoryJob job) {
        if (operation == null) {
            InstallWizard wizard = new InstallWizard(this, operation, initialSelections, job);
            ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), wizard);
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
            return dialog.open();
        }
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this, operation, initialSelections, job);
        wizard.setRemediationOperation(remediationOperation);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
        return dialog.open();
    }

    public int openUpdateWizard(boolean skipSelectionsPage, UpdateOperation operation, LoadMetadataRepositoryJob job) {
        return this.openUpdateWizard(skipSelectionsPage, operation, null, job);
    }

    public int openUpdateWizard(boolean skipSelectionsPage, UpdateOperation operation, RemediationOperation remediationOperation, LoadMetadataRepositoryJob job) {
        if (this.getPolicy().getUpdateWizardStyle() == 2 && UpdateSingleIUWizard.validFor(operation)) {
            UpdateSingleIUWizard wizard = new UpdateSingleIUWizard(this, operation);
            WizardDialog dialog = new WizardDialog(ProvUI.getDefaultParentShell(), (IWizard)wizard);
            dialog.create();
            return dialog.open();
        }
        UpdateWizard wizard = new UpdateWizard(this, operation, (Object[])operation.getSelectedUpdates(), job);
        wizard.setRemediationOperation(remediationOperation);
        wizard.setSkipSelectionsPage(skipSelectionsPage);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.update_wizard_context");
        if (wizard.getCurrentStatus().getSeverity() == 4 && remediationOperation != null && remediationOperation.getResolutionResult() != Status.OK_STATUS) {
            wizard.deselectLockedIUs();
        }
        return dialog.open();
    }

    public int openUninstallWizard(Collection<IInstallableUnit> initialSelections, UninstallOperation operation, LoadMetadataRepositoryJob job) {
        UninstallWizard wizard = new UninstallWizard(this, operation, initialSelections, job);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.uinstall_wizard_context");
        return dialog.open();
    }

    public void manipulateRepositories(Shell shell) {
        if (this.policy.getRepositoryPreferencePageId() != null) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)this.policy.getRepositoryPreferencePageId(), null, null);
            dialog.open();
        } else {
            TitleAreaDialog dialog = new TitleAreaDialog(shell){
                RepositoryManipulationPage page;

                protected Control createDialogArea(Composite parent) {
                    this.page = new RepositoryManipulationPage();
                    this.page.setProvisioningUI(ProvisioningUI.this);
                    this.page.init(PlatformUI.getWorkbench());
                    this.page.createControl(parent);
                    this.setTitle(ProvUIMessages.RepositoryManipulationPage_Title);
                    this.setMessage(ProvUIMessages.RepositoryManipulationPage_Description);
                    Control control = this.page.getControl();
                    control.setLayoutData((Object)new GridData(1808));
                    return this.page.getControl();
                }

                protected boolean isResizable() {
                    return true;
                }

                protected void okPressed() {
                    if (this.page.performOk()) {
                        super.okPressed();
                    }
                }

                protected void cancelPressed() {
                    if (this.page.performCancel()) {
                        super.cancelPressed();
                    }
                }
            };
            dialog.open();
        }
    }

    public void schedule(ProvisioningJob job, int errorStyle) {
        job.setUser(true);
        this.runner.schedule(job, errorStyle);
    }

    public void manageJob(Job job, int jobRestartPolicy) {
        this.runner.manageJob(job, jobRestartPolicy);
    }

    public boolean hasScheduledOperations() {
        return this.getSession().hasScheduledOperationsFor(this.profileId);
    }

    public ProvisioningOperationRunner getOperationRunner() {
        return this.runner;
    }

    public void signalRepositoryOperationStart() {
        ++this.runner.eventBatchCount;
        if (Tracing.DEBUG_EVENTS_CLIENT) {
            Tracing.debug((String)("Batch Count Incremented to:  " + Integer.toString(this.runner.eventBatchCount)));
        }
        ProvUI.getProvisioningEventBus(this.getSession()).publishEvent((EventObject)new RepositoryOperationBeginningEvent(this));
    }

    public void signalRepositoryOperationComplete(RepositoryEvent event, boolean update) {
        --this.runner.eventBatchCount;
        if (Tracing.DEBUG_EVENTS_CLIENT) {
            Tracing.debug((String)("Batch Count Decremented to:  " + Integer.toString(this.runner.eventBatchCount)));
        }
        ProvUI.getProvisioningEventBus(this.getSession()).publishEvent((EventObject)new RepositoryOperationEndingEvent(this, update, event));
    }

    public IMetadataRepository loadMetadataRepository(URI location, boolean notify, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepository repo = null;
        try {
            try {
                this.signalRepositoryOperationStart();
                IMetadataRepositoryManager manager = ProvUI.getMetadataRepositoryManager(this.getSession());
                repo = manager.loadRepository(location, monitor);
                String name = manager.getRepositoryProperty(location, "p2.nickname");
                if ((name == null || name.isEmpty()) && (name = repo.getName()) != null && !name.isEmpty()) {
                    manager.setRepositoryProperty(location, "p2.nickname", name);
                }
            }
            catch (ProvisionException e) {
                this.getRepositoryTracker().reportLoadFailure(location, e);
                this.signalRepositoryOperationComplete(null, notify);
            }
        }
        finally {
            this.signalRepositoryOperationComplete(null, notify);
        }
        return repo;
    }

    public IArtifactRepository loadArtifactRepository(URI location, boolean update, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepository repo;
        this.signalRepositoryOperationStart();
        try {
            IArtifactRepositoryManager manager = ProvUI.getArtifactRepositoryManager(this.getSession());
            repo = manager.loadRepository(location, monitor);
            String name = manager.getRepositoryProperty(location, "p2.nickname");
            if (name == null && (name = manager.getRepositoryProperty(location, "name")) != null) {
                manager.setRepositoryProperty(location, "p2.nickname", name);
            }
        }
        finally {
            this.signalRepositoryOperationComplete(null, update);
        }
        return repo;
    }
}

