/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class TreeTableCommon {
    TreeTableCommon() {
    }

    static Image getDragSourceImage(Control control) {
        long surface;
        long[] model;
        long handle = control.handle;
        long selection = GTK.gtk_tree_view_get_selection(handle);
        long list = GTK.gtk_tree_selection_get_selected_rows(selection, model = null);
        if (list == 0L) {
            return null;
        }
        int count = Math.min(10, OS.g_list_length(list));
        long originalList = list;
        Display display = control.getDisplay();
        int width = 0;
        int height = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        int[] yy = new int[count];
        int[] hh = new int[count];
        long[] icons = new long[count];
        GdkRectangle rect = new GdkRectangle();
        int i = 0;
        while (i < count) {
            long path = OS.g_list_data(list);
            GTK.gtk_tree_view_get_cell_area(handle, path, 0L, rect);
            icons[i] = GTK.gtk_tree_view_create_row_drag_icon(handle, path);
            switch (Cairo.cairo_surface_get_type(icons[i])) {
                case 0: {
                    w[0] = Cairo.cairo_image_surface_get_width(icons[i]);
                    h[0] = Cairo.cairo_image_surface_get_height(icons[i]);
                    break;
                }
                case 3: {
                    w[0] = Cairo.cairo_xlib_surface_get_width(icons[i]);
                    h[0] = Cairo.cairo_xlib_surface_get_height(icons[i]);
                }
            }
            width = Math.max(width, w[0]);
            height = rect.y + h[0] - yy[0];
            yy[i] = rect.y;
            hh[i] = h[0];
            list = OS.g_list_next(list);
            GTK.gtk_tree_path_free(path);
            ++i;
        }
        OS.g_list_free(originalList);
        originalList = 0L;
        list = 0L;
        GtkAllocation controlSize = new GtkAllocation();
        GTK.gtk_widget_get_allocation(handle, controlSize);
        int sourceWidth = width;
        width = Math.min(width, controlSize.width);
        if (count == 1 && sourceWidth == width) {
            surface = icons[0];
        } else {
            long cairo;
            surface = Cairo.cairo_image_surface_create(0, width, height);
            if (surface == 0L) {
                SWT.error(2);
            }
            if ((cairo = Cairo.cairo_create(surface)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(cairo, 1);
            int i2 = 0;
            while (i2 < count) {
                Cairo.cairo_set_source_surface(cairo, icons[i2], 2.0, yy[i2] - yy[0] + 2);
                Cairo.cairo_rectangle(cairo, 0.0, yy[i2] - yy[0], width, hh[i2]);
                Cairo.cairo_fill(cairo);
                Cairo.cairo_surface_destroy(icons[i2]);
                ++i2;
            }
            Cairo.cairo_destroy(cairo);
        }
        Image dragSourceImage = Image.gtk_new(display, 1, surface, 0L);
        return dragSourceImage;
    }
}

