/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.parsers.custom;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.tests.parsers.custom.AbstractCustomTraceIndexTest;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;

public class CustomTxtIndexTest
extends AbstractCustomTraceIndexTest {
    private static final String TRACE_DIRECTORY = TmfTraceManager.getTemporaryDirPath() + File.separator + "dummyTxtTrace";
    private static final String TRACE_PATH = TRACE_DIRECTORY + File.separator + "test.txt";
    private static final String DEFINITION_PATH = "testfiles" + File.separator + "txt" + File.separator + "testTxtDefinition.xml";

    private static CustomTxtTraceDefinition createDefinition() {
        CustomTxtTraceDefinition[] definitions = CustomTxtTraceDefinition.loadAll((String)new File(DEFINITION_PATH).toString());
        return definitions[0];
    }

    @Override
    protected String getTraceDirectory() {
        return TRACE_DIRECTORY;
    }

    @Override
    protected AbstractCustomTraceIndexTest.TestTrace createTrace() throws Exception {
        CustomTxtTraceDefinition definition = CustomTxtIndexTest.createDefinition();
        File file = new File(TRACE_PATH);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            int i = 0;
            while (i < 10000) {
                SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
                String eventStr = f.format(new Date(i)) + " hello world\n";
                writer.write(eventStr);
                int extra = i % 3;
                int j = 0;
                while (j < extra) {
                    writer.write("extra line\n");
                    ++j;
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new TestTxtTrace(file.toString(), definition, 100);
    }

    private class TestTxtTrace
    extends CustomTxtTrace
    implements AbstractCustomTraceIndexTest.TestTrace {
        public TestTxtTrace(String path, CustomTxtTraceDefinition createDefinition, int blockSize) throws TmfTraceException {
            super(null, createDefinition, path, blockSize);
        }

        protected ITmfTraceIndexer createIndexer(int interval) {
            return new AbstractCustomTraceIndexTest.TestIndexer(this, interval);
        }

        @Override
        public AbstractCustomTraceIndexTest.TestIndexer getIndexer() {
            return (AbstractCustomTraceIndexTest.TestIndexer)super.getIndexer();
        }
    }
}

