/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class RegionUpdateRule {
    public static boolean allLetterOrDigit(String changes) {
        boolean result = true;
        int i = 0;
        while (i < changes.length()) {
            if (!Character.isLetterOrDigit(changes.charAt(i))) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean allWhiteSpace(String changes) {
        boolean result = true;
        int i = 0;
        while (i < changes.length()) {
            if (!Character.isWhitespace(changes.charAt(i))) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean canHandleAsLetterOrDigit(ITextRegion region, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        if (parent == null) {
            return RegionUpdateRule.canHandleAsLetterOrDigit(region, changes, requestStart, lengthToReplace);
        }
        boolean result = false;
        if (requestStart <= parent.getTextEndOffset(region) && RegionUpdateRule.allLetterOrDigit(changes)) {
            result = true;
        }
        return result;
    }

    public static boolean canHandleAsLetterOrDigit(ITextRegion region, String changes, int requestStart, int lengthToReplace) {
        boolean result = false;
        if (requestStart <= region.getTextEnd() && RegionUpdateRule.allLetterOrDigit(changes)) {
            result = true;
        }
        return result;
    }

    public static boolean canHandleAsWhiteSpace(ITextRegion region, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        if (parent == null) {
            return RegionUpdateRule.canHandleAsWhiteSpace(region, changes, requestStart, lengthToReplace);
        }
        boolean result = false;
        if (region.getEnd() > region.getTextEnd() && requestStart >= parent.getTextEndOffset(region)) {
            result = RegionUpdateRule.allWhiteSpace(changes);
        }
        return result;
    }

    public static boolean canHandleAsWhiteSpace(ITextRegion region, String changes, int requestStart, int lengthToReplace) {
        boolean result = false;
        if (region.getEnd() > region.getTextEnd() && requestStart >= region.getTextEnd()) {
            result = RegionUpdateRule.allWhiteSpace(changes);
        }
        return result;
    }

    public static StructuredDocumentEvent updateModel(ITextRegion region, Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        RegionChangedEvent result = null;
        boolean canHandle = false;
        canHandle = changes == null || changes.length() == 0 ? region.getStart() < region.getTextEnd() && Math.abs(lengthToReplace) < region.getTextEnd() - region.getStart() : RegionUpdateRule.canHandleAsWhiteSpace(region, parent, changes, requestStart, lengthToReplace) || RegionUpdateRule.canHandleAsLetterOrDigit(region, parent, changes, requestStart, lengthToReplace);
        if (canHandle) {
            int lengthDifference = Utilities.calculateLengthDifference((String)changes, (int)lengthToReplace);
            region.adjustLength(lengthDifference);
            RegionUpdateRule.canHandleAsWhiteSpace(region, parent, changes, region.getStart(), lengthToReplace);
            result = new RegionChangedEvent(parent.getParentDocument(), requester, parent, region, changes, requestStart, lengthToReplace);
        }
        return result;
    }
}

