/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.quickoutline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.sse.ui.IContentSelectionProvider;
import org.eclipse.wst.sse.ui.quickoutline.AbstractQuickOutlineConfiguration;
import org.eclipse.wst.sse.ui.quickoutline.StringMatcher;
import org.eclipse.wst.sse.ui.quickoutline.StringPatternFilter;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.eclipse.wst.xml.ui.internal.quickoutline.XMLContentLabelProvider;
import org.eclipse.wst.xml.ui.internal.quickoutline.XMLContentSelectionProvider;

public final class XMLQuickOutlineConfigurationForContents
extends AbstractQuickOutlineConfiguration {
    XMLContentLabelProvider fLastLabelProvider = null;

    public ITreeContentProvider getContentProvider() {
        return new JFaceNodeContentProvider();
    }

    public IContentSelectionProvider getContentSelectionProvider() {
        return new XMLContentSelectionProvider();
    }

    public ILabelProvider getLabelProvider() {
        XMLContentLabelProvider labelProvider = this.fLastLabelProvider = new XMLContentLabelProvider();
        labelProvider.showAttributes(true);
        return labelProvider;
    }

    public String getShowMessage() {
        return XMLUIMessages.QuickOutlineShowAttributes;
    }

    public StringPatternFilter getFilter() {
        return new StringPatternFilter(){

            public void updatePattern(String pattern) {
                this.fStringMatcher = pattern.length() == 0 ? null : new IdMatcher(pattern, pattern.toLowerCase().equals(pattern), false);
            }

            protected String getMatchLabel(Object element, TreeViewer treeViewer) {
                String matchLabel;
                if (XMLQuickOutlineConfigurationForContents.this.fLastLabelProvider != null && (matchLabel = XMLQuickOutlineConfigurationForContents.this.fLastLabelProvider.getIdMatchValue(element)) != null) {
                    return matchLabel;
                }
                return super.getMatchLabel(element, treeViewer);
            }
        };
    }

    static class IdMatcher
    extends StringMatcher {
        public IdMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            super(pattern, ignoreCase, ignoreWildCards);
        }

        public boolean match(String text) {
            int length = text.length();
            int subStartPos = 0;
            int subEndPos = 0;
            while (subEndPos + 1 < length && (subEndPos = text.indexOf(10, subStartPos)) > 1) {
                if (this.match(text, subStartPos, subEndPos)) {
                    return true;
                }
                subStartPos = subEndPos + 1;
            }
            int valueStart = text.indexOf(61, 1);
            if (valueStart > 1 && valueStart + 1 < length) {
                if (this.match(text, valueStart + 1, length)) {
                    return true;
                }
                if (text.length() > valueStart && (valueStart = text.indexOf(61, valueStart + 1)) > 1) {
                    return this.match(text, valueStart + 1, length);
                }
            }
            if ((valueStart = text.indexOf(" : ", 1)) > 1 && valueStart + 3 < length) {
                return this.match(text, valueStart + 3, length);
            }
            return super.match(text, subStartPos, length);
        }
    }
}

