/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSpecification;

public class FindNodeForOffsetAction
extends ASTGenericVisitor {
    private final ASTNodeSpecification<?> fNodeSpec;

    public FindNodeForOffsetAction(ASTNodeSpecification<?> nodeSpec) {
        super(!nodeSpec.requiresClass(IASTName.class));
        this.fNodeSpec = nodeSpec;
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.includeInactiveNodes = true;
        this.shouldVisitImplicitNames = this.shouldVisitImplicitNameAlternates = nodeSpec.requiresClass(IASTImplicitName.class);
    }

    @Override
    public int genericVisit(IASTNode node) {
        if (node instanceof ASTNode) {
            ASTNode astNode = (ASTNode)node;
            if (!this.fNodeSpec.canContainMatches(astNode)) {
                return 1;
            }
            this.fNodeSpec.visit(astNode);
        }
        return 3;
    }

    @Override
    public int visit(IASTDeclaration declaration) {
        if (declaration instanceof ASTNode && ((ASTNode)((Object)declaration)).getOffset() > this.fNodeSpec.getSequenceEnd()) {
            return 2;
        }
        return this.genericVisit(declaration);
    }

    @Override
    public int visit(IASTDeclarator declarator) {
        int ret = this.genericVisit(declarator);
        IASTPointerOperator[] ops = declarator.getPointerOperators();
        int i = 0;
        while (i < ops.length) {
            this.genericVisit(ops[i]);
            ++i;
        }
        return ret;
    }
}

