/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.compress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.internal.compress.Compress;
import org.eclipse.swtchart.model.Node;
import org.eclipse.swtchart.model.NodeDataModel;

public class CompressCircularSeries
extends Compress {
    private NodeDataModel nodeDataModel;
    private int maxTreeDepth;

    public CompressCircularSeries(NodeDataModel nodeDataModel) {
        this.nodeDataModel = nodeDataModel;
    }

    @Override
    protected void addNecessaryPlots(ArrayList<Double> xList, ArrayList<Double> yList, ArrayList<Integer> indexList) {
    }

    public void update() {
        this.updateColors();
    }

    private void updateColors() {
        Display device = Display.getDefault();
        this.maxTreeDepth = this.nodeDataModel.getRootPointer().getMaxSubTreeDepth() - 1;
        List<Node>[] nodes = this.nodeDataModel.getNodes();
        int i = 1;
        while (i <= this.maxTreeDepth) {
            int length = nodes[i].size();
            float anglePerNode = 360.0f / (float)length;
            float brightness = Math.max(0.0f, (float)(i - 1) / (float)this.maxTreeDepth);
            int j = 0;
            while (j != length) {
                RGB rgb = new RGB(anglePerNode * (float)j, 1.0f, 1.0f - brightness);
                Color color = new Color((Device)device, rgb);
                nodes[i].get(j).setSliceColor(color);
                ++j;
            }
            ++i;
        }
    }
}

