/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;

public class XMLCatalogEntryContentProvider
implements ITreeContentProvider {
    protected Object[] roots = new Object[2];
    private ICatalog fWorkingUserCatalog;
    private ICatalog fSystemCatalog;
    static final String USER_SPECIFIED_ENTRIES_OBJECT = XMLCatalogMessages.UI_LABEL_USER_SPECIFIED_ENTRIES;
    static final String PLUGIN_SPECIFIED_ENTRIES_OBJECT = XMLCatalogMessages.UI_LABEL_PLUGIN_SPECIFIED_ENTRIES;

    public XMLCatalogEntryContentProvider() {
        this.roots[0] = USER_SPECIFIED_ENTRIES_OBJECT;
        this.roots[1] = PLUGIN_SPECIFIED_ENTRIES_OBJECT;
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null) {
                if ("system_catalog".equals(referencedCatalog.getId())) {
                    this.fSystemCatalog = referencedCatalog;
                } else if ("user_catalog".equals(referencedCatalog.getId())) {
                    this.fWorkingUserCatalog = referencedCatalog;
                }
            }
            ++i;
        }
    }

    public boolean isRoot(Object object) {
        return object instanceof String || object instanceof INextCatalog;
    }

    public Object[] getElements(Object element) {
        return this.roots;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        if (parentElement == this.roots[0]) {
            result = this.getChildrenHelper(this.fWorkingUserCatalog);
        } else if (parentElement == this.roots[1]) {
            result = this.getChildrenHelper(this.fSystemCatalog);
        } else if (parentElement instanceof INextCatalog) {
            ICatalog nextCatalog = ((INextCatalog)parentElement).getReferencedCatalog();
            result = this.getChildrenHelper(nextCatalog);
        } else if (parentElement instanceof IDelegateCatalog) {
            ICatalog nextCatalog = ((IDelegateCatalog)parentElement).getReferencedCatalog();
            result = this.getChildrenHelper(nextCatalog);
        }
        return result;
    }

    protected Object[] getChildrenHelper(ICatalog catalog) {
        ICatalogEntry[] entries = catalog.getCatalogEntries();
        if (entries.length > 0) {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    int result = 0;
                    if (o1 instanceof ICatalogEntry && o2 instanceof ICatalogEntry) {
                        ICatalogEntry entry1 = (ICatalogEntry)o1;
                        ICatalogEntry entry2 = (ICatalogEntry)o2;
                        result = Collator.getInstance().compare(entry1.getKey(), entry2.getKey());
                    }
                    return result;
                }
            };
            Arrays.sort(entries, comparator);
        }
        Vector<Object> result = new Vector<Object>();
        result.addAll(Arrays.asList(entries));
        result.addAll(Arrays.asList(catalog.getRewriteEntries()));
        result.addAll(Arrays.asList(catalog.getSuffixEntries()));
        result.addAll(Arrays.asList(catalog.getDelegateCatalogs()));
        INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
        List<INextCatalog> nextCatalogsList = Arrays.asList(nextCatalogs);
        result.addAll(nextCatalogsList);
        return result.toArray(new ICatalogElement[result.size()]);
    }

    public Object getParent(Object element) {
        return element instanceof String ? null : USER_SPECIFIED_ENTRIES_OBJECT;
    }

    public boolean hasChildren(Object element) {
        return this.isRoot(element) ? this.getChildren(element).length > 0 : false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object old, Object newobj) {
    }

    public boolean isDeleted(Object object) {
        return false;
    }
}

