/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConceptDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConcept;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPConcept
extends PlatformObject
implements ICPPConcept {
    protected ICPPASTConceptDefinition definition;
    private ICPPTemplateParameter[] templateParameters;

    public CPPConcept(ICPPASTConceptDefinition definition) {
        this.definition = definition;
    }

    private IASTName getTemplateName() {
        return this.getASTName();
    }

    @Override
    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.templateParameters == null) {
            ICPPTemplateParameter[] result = ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
            ICPPASTTemplateDeclaration template = CPPTemplates.getTemplateDeclaration(this.getTemplateName());
            if (template != null) {
                ICPPASTTemplateParameter[] params;
                ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = params = template.getTemplateParameters();
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
                    IBinding p = CPPTemplates.getTemplateParameterName(param).resolveBinding();
                    if (p instanceof ICPPTemplateParameter) {
                        result = ArrayUtil.append(result, (ICPPTemplateParameter)p);
                    }
                    ++n2;
                }
            }
            this.templateParameters = ArrayUtil.trim(result);
        }
        return this.templateParameters;
    }

    @Override
    public ICPPASTConceptDefinition getConceptDefinition() {
        return this.definition;
    }

    @Override
    public String[] getQualifiedName() throws DOMException {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() throws DOMException {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        return true;
    }

    @Override
    public String getName() {
        return this.getASTName().toString();
    }

    @Override
    public char[] getNameCharArray() {
        return this.getASTName().getSimpleID();
    }

    protected IASTName getASTName() {
        return this.definition.getName();
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findNameOwner(this.getASTName(), false);
    }

    @Override
    public IScope getScope() throws DOMException {
        return CPPVisitor.getContainingScope(this.getASTName());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("concept ");
        result.append(this.getName());
        return result.toString();
    }
}

