/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;

public class MappingsComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int propertyIndex = 0;
    private int direction = 1;

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof MappedSeriesSettings && e2 instanceof MappedSeriesSettings) {
            MappedSeriesSettings mappedSeriesSettings1 = (MappedSeriesSettings)e1;
            MappedSeriesSettings mappedSeriesSettings2 = (MappedSeriesSettings)e2;
            switch (this.propertyIndex) {
                case 0: {
                    sortOrder = mappedSeriesSettings1.getMappingsType().compareTo(mappedSeriesSettings2.getMappingsType());
                    break;
                }
                case 1: {
                    sortOrder = mappedSeriesSettings1.getIdentifier().compareTo(mappedSeriesSettings2.getIdentifier());
                    break;
                }
                case 2: {
                    sortOrder = mappedSeriesSettings1.getDescription().compareTo(mappedSeriesSettings2.getDescription());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.direction == 1) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

