/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class MultipartSupportPart
implements Part {
    private final DiskFileItem item;
    private final FileItemHeaders headers;

    public MultipartSupportPart(DiskFileItem item) {
        this.item = item;
        this.headers = item.getHeaders();
    }

    public InputStream getInputStream() throws IOException {
        return this.item.getInputStream();
    }

    public String getContentType() {
        return this.item.getContentType();
    }

    public String getName() {
        return this.item.getFieldName();
    }

    public String getSubmittedFileName() {
        return this.item.getName();
    }

    public long getSize() {
        return this.item.getSize();
    }

    public void write(String fileName) throws IOException {
        try {
            this.item.write(new File(this.item.getStoreLocation(), fileName));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void delete() {
        this.item.delete();
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return new IteratorCollection(this.headers.getHeaders(name));
    }

    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return new IteratorCollection(this.headers.getHeaderNames());
    }

    private static class IteratorCollection
    extends AbstractList<String> {
        private final List<String> collection = new ArrayList<String>();

        public IteratorCollection(Iterator<String> iterator) {
            while (iterator.hasNext()) {
                this.collection.add(iterator.next());
            }
        }

        @Override
        public String get(int index) {
            return this.collection.get(index);
        }

        @Override
        public int size() {
            return this.collection.size();
        }
    }
}

