/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.registry;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.osgi.framework.Bundle;

public class CheatSheetElement
extends WorkbenchAdapter
implements IAdaptable,
IPluginContribution {
    private String contentFile;
    private String id;
    private final String name;
    private String description;
    private IConfigurationElement configurationElement;
    private String listenerClass;
    private boolean composite;
    private boolean registered = false;
    private String contentXml;
    private String href;

    public CheatSheetElement(String name) {
        this.name = name;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return adapter.cast((Object)this);
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getContentFile() {
        return this.contentFile;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel(Object element) {
        return this.name;
    }

    public String getListenerClass() {
        return this.listenerClass;
    }

    public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
        this.configurationElement = newConfigurationElement;
    }

    public void setContentFile(String value) {
        this.contentFile = value;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setID(String value) {
        this.id = value;
    }

    public void setListenerClass(String value) {
        this.listenerClass = value;
    }

    public CheatSheetListener createListenerInstance() {
        String message;
        if (this.listenerClass == null || this.configurationElement == null) {
            return null;
        }
        Class extClass = null;
        CheatSheetListener listener = null;
        String pluginId = this.configurationElement.getContributor().getName();
        try {
            Bundle bundle = Platform.getBundle((String)pluginId);
            extClass = bundle.loadClass(this.listenerClass);
        }
        catch (Exception e) {
            message = NLS.bind((String)Messages.ERROR_LOADING_CLASS, (Object[])new Object[]{this.listenerClass});
            CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
        }
        try {
            if (extClass != null) {
                listener = (CheatSheetListener)extClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            message = NLS.bind((String)Messages.ERROR_CREATING_CLASS, (Object[])new Object[]{this.listenerClass});
            CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
        }
        if (listener != null) {
            return listener;
        }
        return null;
    }

    public String getLocalId() {
        return this.id;
    }

    public String getPluginId() {
        return this.configurationElement.getContributor().getName();
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public String getRestorePath() {
        if (!this.registered) {
            return this.contentFile;
        }
        return null;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setContentXml(String xml) {
        this.contentXml = xml;
    }

    public String getContentXml() {
        return this.contentXml;
    }

    public void setHref(String contentPath) {
        this.href = contentPath;
    }

    public String getHref() {
        return this.href;
    }
}

