/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.util.List;
import org.apache.lucene.util.ArrayUtil;

public record BKDConfig(int numDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode) {
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 512;
    public static final int MAX_DIMS = 16;
    public static final int MAX_INDEX_DIMS = 8;
    private static final List<BKDConfig> DEFAULT_CONFIGS = List.of(new BKDConfig(1, 1, 2, 512), new BKDConfig(1, 1, 4, 512), new BKDConfig(1, 1, 8, 512), new BKDConfig(1, 1, 16, 512), new BKDConfig(2, 2, 2, 512), new BKDConfig(2, 2, 4, 512), new BKDConfig(2, 2, 8, 512), new BKDConfig(2, 2, 16, 512), new BKDConfig(7, 4, 4, 512));

    public BKDConfig {
        if (numDims < 1 || numDims > 16) {
            throw new IllegalArgumentException("numDims must be 1 .. 16 (got: " + numDims + ")");
        }
        if (numIndexDims < 1 || numIndexDims > 8) {
            throw new IllegalArgumentException("numIndexDims must be 1 .. 8 (got: " + numIndexDims + ")");
        }
        if (numIndexDims > numDims) {
            throw new IllegalArgumentException("numIndexDims cannot exceed numDims (" + numDims + ") (got: " + numIndexDims + ")");
        }
        if (bytesPerDim <= 0) {
            throw new IllegalArgumentException("bytesPerDim must be > 0; got " + bytesPerDim);
        }
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
    }

    public static BKDConfig of(int numDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode) {
        BKDConfig config = new BKDConfig(numDims, numIndexDims, bytesPerDim, maxPointsInLeafNode);
        int defaultConfigIndex = DEFAULT_CONFIGS.indexOf(config);
        if (defaultConfigIndex != -1) {
            return DEFAULT_CONFIGS.get(defaultConfigIndex);
        }
        return config;
    }

    public int packedBytesLength() {
        return this.numDims * this.bytesPerDim;
    }

    public int packedIndexBytesLength() {
        return this.numIndexDims * this.bytesPerDim;
    }

    public int bytesPerDoc() {
        return this.packedBytesLength() + 4;
    }
}

