/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search.pattern;

public class QualifiedName {
    private String qualifier;
    private String name;
    private static final String NS_DELIM_1 = "{";
    private static final String NS_DELIM_2 = "}";

    public QualifiedName(String namespace, String localName) {
        this.qualifier = namespace;
        if (namespace != null && namespace.length() == 0) {
            this.qualifier = null;
        }
        if (this.qualifier != null && this.qualifier.length() == 0) {
            this.qualifier = null;
        }
        this.name = localName;
        if (localName != null && localName.length() == 0) {
            this.name = null;
        }
    }

    public String getNamespace() {
        return this.qualifier;
    }

    public String getLocalName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj instanceof QualifiedName) {
            QualifiedName that = (QualifiedName)obj;
            isEqual = this.isMatch(this.getNamespace(), that.getNamespace()) && this.isMatch(this.getLocalName(), that.getLocalName());
        }
        return isEqual;
    }

    protected boolean isMatch(String a, String b) {
        return a != null ? a.equals(b) : a == b;
    }

    public int hashCode() {
        int hash = 0;
        if (this.qualifier != null) {
            hash += this.qualifier.hashCode();
        }
        if (this.name != null) {
            hash += this.name.hashCode();
        }
        return hash;
    }

    public String toString() {
        return QualifiedName.appendStrings(new String[]{NS_DELIM_1, this.qualifier, NS_DELIM_2, this.name});
    }

    public static QualifiedName valueOf(String qnameString) throws IllegalArgumentException {
        String namespace = null;
        String localName = null;
        if (qnameString != null && qnameString.length() != 0) {
            if (qnameString.startsWith(NS_DELIM_1)) {
                int index = qnameString.indexOf(NS_DELIM_2);
                if (index == -1) {
                    throw new IllegalArgumentException("qnameString = " + qnameString);
                }
                namespace = qnameString.substring(1, index);
                localName = qnameString.substring(index + 1);
            } else {
                localName = qnameString;
            }
        }
        return new QualifiedName(namespace, localName);
    }

    public static String appendStrings(String[] strings) {
        String result = null;
        if (strings != null) {
            StringBuffer tokenBuffer = new StringBuffer();
            int maxCount = strings.length;
            int i = 0;
            while (i < maxCount) {
                String string = strings[i];
                if (string != null && string.length() > 0) {
                    tokenBuffer.append(string);
                }
                ++i;
            }
            result = tokenBuffer.toString();
        }
        return result;
    }
}

