/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tracecompass.analysis.profiling.core.model.IHostModel;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.CompositeHostModel;

public final class ModelManager {
    private static final Map<String, IHostModel> MODELS_FOR_HOST = new HashMap<String, IHostModel>();

    private ModelManager() {
    }

    public static synchronized IHostModel getModelFor(String hostId) {
        IHostModel model = MODELS_FOR_HOST.get(hostId);
        if (model == null) {
            model = new CompositeHostModel(hostId);
            MODELS_FOR_HOST.put(hostId, model);
        }
        return model;
    }

    public static synchronized void disposeModels() {
        MODELS_FOR_HOST.values().forEach(IHostModel::dispose);
        MODELS_FOR_HOST.clear();
    }
}

