/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.NextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.osgi.framework.Bundle;

public class CatalogContributorRegistryReader {
    protected static final String EXTENSION_POINT_ID = "catalogContributions";
    protected static final String TAG_CONTRIBUTION = "catalogContribution";
    protected ICatalog catalog;
    protected String declaringExtensionId;

    protected CatalogContributorRegistryReader(ICatalog aCatalog) {
        this.catalog = aCatalog;
    }

    protected void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    public static String resolvePath(URL platformURL, String path) {
        String fileLocation = path;
        int jarPathStart = path.indexOf("jar:");
        jarPathStart = jarPathStart < 0 ? 0 : jarPathStart + "jar:".length();
        int jarPathEnd = path.indexOf("!");
        jarPathEnd = jarPathEnd < 0 ? path.length() : jarPathEnd;
        fileLocation = path.substring(jarPathStart, jarPathEnd);
        String result = path;
        String resolvedLocation = fileLocation;
        URL resolvedURL = null;
        if (fileLocation.startsWith("platform:/plugin")) {
            try {
                resolvedURL = FileLocator.resolve((URL)new URL(fileLocation));
            }
            catch (IOException iOException) {}
        } else {
            try {
                resolvedURL = new URL(Platform.resolve((URL)platformURL), fileLocation);
            }
            catch (IOException iOException) {}
        }
        if (resolvedURL != null) {
            resolvedLocation = resolvedURL.toExternalForm().replace('\\', '/');
            result = result.replaceFirst(fileLocation, resolvedLocation);
        }
        return result;
    }

    public static URL getPlatformURL(String pluginId) {
        URL bundleEntry;
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && (bundleEntry = bundle.getEntry("/")) != null) {
            try {
                return Platform.resolve((URL)bundleEntry);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    private String resolvePath(String path) {
        return CatalogContributorRegistryReader.resolvePath(CatalogContributorRegistryReader.getPlatformURL(this.declaringExtensionId), path);
    }

    protected void readElement(IConfigurationElement element) {
        try {
            this.declaringExtensionId = element.getDeclaringExtension().getNamespace();
        }
        catch (InvalidRegistryObjectException e) {
            Logger.logException(e);
        }
        if (TAG_CONTRIBUTION.equals(element.getName())) {
            IConfigurationElement[] mappingInfoElementList = element.getChildren("public");
            this.processMappingInfoElements(mappingInfoElementList);
            mappingInfoElementList = element.getChildren("system");
            this.processMappingInfoElements(mappingInfoElementList);
            mappingInfoElementList = element.getChildren("uri");
            this.processMappingInfoElements(mappingInfoElementList);
            IConfigurationElement[] nextCatalogElementList = element.getChildren("nextCatalog");
            this.processNextCatalogElements(nextCatalogElementList);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processMappingInfoElements(IConfigurationElement[] childElementList) {
        if (this.catalog == null) {
            return;
        }
        i = 0;
        while (i < childElementList.length) {
            block14: {
                block13: {
                    block12: {
                        childElement = childElementList[i];
                        name = childElement.getName();
                        key = null;
                        type = 2;
                        if (!"public".equals(name)) break block12;
                        key = childElement.getAttribute("publicId");
                        ** GOTO lbl-1000
                    }
                    if (!"system".equals(name)) break block13;
                    key = childElement.getAttribute("systemId");
                    type = 3;
                    ** GOTO lbl-1000
                }
                if (!"uri".equals(name)) break block14;
                key = childElement.getAttribute("name");
                type = 4;
                ** GOTO lbl-1000
            }
            if ("nextCatalog".equals(name)) {
                this.processNextCatalogElements(new IConfigurationElement[]{childElement});
            } else if (key == null || key.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_entry_key_not_set);
            } else {
                entryURI = childElement.getAttribute("uri");
                if (entryURI == null || entryURI.equals("")) {
                    Logger.log(4, XMLCoreMessages.Catalog_entry_uri_not_set);
                } else {
                    catalogElement = this.catalog.createCatalogElement(type);
                    if (catalogElement instanceof ICatalogEntry) {
                        entry = (ICatalogEntry)catalogElement;
                        entry.setKey(key);
                        resolvedPath = this.resolvePath(entryURI);
                        entry.setURI(resolvedPath);
                        id = childElement.getAttribute("id");
                        if (id != null && !id.equals("")) {
                            entry.setId(id);
                        }
                    }
                    j = 0;
                    while (j < childElement.getAttributeNames().length) {
                        attrName = childElement.getAttributeNames()[j];
                        if (!(attrName.equals("uri") || attrName.equals("name") || attrName.equals("publicId") || attrName.equals("systemId") || attrName.equals("catalog") || attrName.equals("id") || attrName.equals("xml:base") || (attrValue = childElement.getAttribute(attrName)) == null || attrValue.equals(""))) {
                            catalogElement.setAttributeValue(attrName, attrValue);
                        }
                        ++j;
                    }
                    this.catalog.addCatalogElement(catalogElement);
                }
            }
            ++i;
        }
    }

    private void processNextCatalogElements(IConfigurationElement[] childElementList) {
        if (this.catalog == null) {
            return;
        }
        int i = 0;
        while (i < childElementList.length) {
            IConfigurationElement childElement = childElementList[i];
            String location = childElement.getAttribute("catalog");
            if (location == null || location.equals("")) {
                Logger.log(4, XMLCoreMessages.Catalog_next_catalog_location_uri_not_set);
            } else {
                NextCatalog nextCatalog = new NextCatalog();
                String resolvedPath = this.resolvePath(location);
                nextCatalog.setCatalogLocation(resolvedPath);
                String id = childElement.getAttribute("id");
                if (id != null && !id.equals("")) {
                    nextCatalog.setId(id);
                }
                this.catalog.addCatalogElement(nextCatalog);
            }
            ++i;
        }
    }
}

