/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.variables;

import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ShowTypesAction
extends Action {
    private IDebugView fView;

    public ShowTypesAction(IDebugView view) {
        super(ActionMessages.ShowTypesAction_Show__Type_Names_1, 2);
        this.setView(view);
        this.setToolTipText(ActionMessages.ShowTypesAction_Show_Type_Names);
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_TYPE_NAMES"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_TYPE_NAMES"));
        this.setId(DebugUIPlugin.getUniqueIdentifier() + ".ShowTypesAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.show_types_action_context");
    }

    public void run() {
        this.valueChanged(this.isChecked());
    }

    private void valueChanged(boolean on) {
        Viewer viewer = this.getView().getViewer();
        if (viewer.getControl().isDisposed()) {
            return;
        }
        IDebugModelPresentation debugLabelProvider = (IDebugModelPresentation)this.getView().getAdapter(IDebugModelPresentation.class);
        if (debugLabelProvider != null) {
            Boolean typesStatus = on ? Boolean.TRUE : Boolean.FALSE;
            debugLabelProvider.setAttribute("org.eclipse.debug.ui.displayVariableTypeNames", typesStatus);
            if (viewer instanceof TreeModelViewer) {
                TreeModelViewer treeViewer = (TreeModelViewer)viewer;
                treeViewer.getPresentationContext().setProperty("org.eclipse.debug.ui.displayVariableTypeNames", typesStatus);
            }
            BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), () -> viewer.refresh());
        }
    }

    protected IDebugView getView() {
        return this.fView;
    }

    protected void setView(IDebugView view) {
        this.fView = view;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setToolTipText(ActionMessages.ShowTypesAction_Show_Type_Names);
        } else {
            this.setToolTipText(ActionMessages.ShowTypesAction_0);
        }
    }
}

