/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.model.AdaptableList;

public class TraceFileSystemElement
extends FileSystemElement {
    private boolean fIsPopulated = false;
    private String fLabel = null;
    private IPath fDestinationContainerPath;
    private FileSystemObjectImportStructureProvider fProvider;
    private String fSourceLocation;

    public TraceFileSystemElement(String name, FileSystemElement parent, boolean isDirectory, FileSystemObjectImportStructureProvider provider) {
        super(name, parent, isDirectory);
        this.fProvider = provider;
    }

    public void setDestinationContainerPath(IPath destinationContainerPath) {
        this.fDestinationContainerPath = destinationContainerPath;
    }

    public void setPopulated() {
        this.fIsPopulated = true;
    }

    public boolean isPopulated() {
        return this.fIsPopulated;
    }

    public AdaptableList getFiles() {
        if (!this.fIsPopulated) {
            this.populateElementChildren();
        }
        return super.getFiles();
    }

    public AdaptableList getFolders() {
        if (!this.fIsPopulated) {
            this.populateElementChildren();
        }
        return super.getFolders();
    }

    public void setLabel(String name) {
        this.fLabel = name;
    }

    public String getLabel() {
        if (this.fLabel == null) {
            return this.getProvider().getLabel(this.getFileSystemObject());
        }
        return this.fLabel;
    }

    public IPath getDestinationContainerPath() {
        return this.fDestinationContainerPath;
    }

    private void populateElementChildren() {
        List<IFileSystemObject> allchildren = this.fProvider.getChildren(this.getFileSystemObject());
        IFileSystemObject child2 = null;
        TraceFileSystemElement newelement = null;
        for (IFileSystemObject child2 : allchildren) {
            newelement = new TraceFileSystemElement(this.fProvider.getLabel(child2), this, this.fProvider.isFolder(child2), this.fProvider);
            newelement.setFileSystemObject(child2);
        }
        this.setPopulated();
    }

    public FileSystemObjectImportStructureProvider getProvider() {
        return this.fProvider;
    }

    public IFileSystemObject getFileSystemObject() {
        return (IFileSystemObject)super.getFileSystemObject();
    }

    public String getSourceLocation() {
        if (this.fSourceLocation == null) {
            this.fSourceLocation = this.getFileSystemObject().getSourceLocation();
        }
        return this.fSourceLocation;
    }

    public void setSourceLocation(String sourceLocation) {
        this.fSourceLocation = sourceLocation;
    }

    public void getAllChildren(List<TraceFileSystemElement> result) {
        AdaptableList files = this.getFiles();
        Object[] objectArray = files.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            result.add((TraceFileSystemElement)((Object)file));
            ++n2;
        }
        AdaptableList folders = this.getFolders();
        Object[] objectArray2 = folders.getChildren();
        int n3 = objectArray2.length;
        n = 0;
        while (n < n3) {
            Object folder = objectArray2[n];
            TraceFileSystemElement traceElementFolder = (TraceFileSystemElement)((Object)folder);
            traceElementFolder.getAllChildren(result);
            ++n;
        }
    }

    public static TraceFileSystemElement createRootTraceFileElement(IFileSystemObject object, FileSystemObjectImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(object);
        String elementLabel = provider.getLabel(object);
        TraceFileSystemElement dummyParent = new TraceFileSystemElement("", null, true, provider);
        IFileSystemObject dummyParentFileSystemObject = object;
        Object rawFileSystemObject = object.getRawFileSystemObject();
        if (rawFileSystemObject instanceof File) {
            dummyParentFileSystemObject = provider.getIFileSystemObject(((File)rawFileSystemObject).getParentFile());
        }
        dummyParent.setFileSystemObject(dummyParentFileSystemObject);
        dummyParent.setPopulated();
        TraceFileSystemElement result = new TraceFileSystemElement(elementLabel, dummyParent, isContainer, provider);
        result.setFileSystemObject(object);
        result.getFiles();
        return dummyParent;
    }
}

