/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterCu;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.IFilterStrings;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@NonNullByDefault
public final class TmfFilterHelper {
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";

    private TmfFilterHelper() {
    }

    public static @Nullable ITmfFilter buildFilterFromRegex(Collection<String> regexes, ITmfTrace trace) {
        FilterCu compile = FilterCu.compile(IFilterStrings.mergeFilters(regexes));
        if (compile == null) {
            Activator.logInfo("buildFilterFromRegex: Invalid regex");
            return null;
        }
        return compile.getEventFilter(trace);
    }

    public static String getRegexFromFilter(ITmfFilter filter) {
        if (filter instanceof TmfFilterRootNode) {
            return TmfFilterHelper.getRegexFromRootNode((TmfFilterRootNode)filter);
        }
        if (filter instanceof TmfFilterAndNode) {
            return TmfFilterHelper.getRegexFromAndNode((TmfFilterAndNode)filter);
        }
        if (filter instanceof TmfFilterOrNode) {
            return TmfFilterHelper.getRegexFromOrNode((TmfFilterOrNode)filter);
        }
        if (filter instanceof TmfFilterCompareNode) {
            return TmfFilterHelper.getRegexFromCompareNode((TmfFilterCompareNode)filter);
        }
        if (filter instanceof TmfFilterContainsNode) {
            return TmfFilterHelper.getRegexFromContainsNode((TmfFilterContainsNode)filter);
        }
        if (filter instanceof TmfFilterEqualsNode) {
            return TmfFilterHelper.getRegexFromEqualsNode((TmfFilterEqualsNode)filter);
        }
        if (filter instanceof TmfFilterMatchesNode) {
            return TmfFilterHelper.getRegexFromMatchesNode((TmfFilterMatchesNode)filter);
        }
        if (filter instanceof TmfFilterNode) {
            return TmfFilterHelper.joinChildrenRegex((TmfFilterNode)filter, "&&");
        }
        return "";
    }

    private static String getRegexFromMatchesNode(TmfFilterMatchesNode filter) {
        if (filter.getRegex().equals(".*")) {
            String regex = TmfFilterHelper.quote(TmfFilterHelper.getFilterAspectName(filter)) + " present";
            return filter.isNot() ? TmfFilterHelper.not(regex) : regex;
        }
        String regex = TmfFilterHelper.quote(TmfFilterHelper.getFilterAspectName(filter)) + " matches " + TmfFilterHelper.quote(filter.getRegex());
        return filter.isNot() ? TmfFilterHelper.not(regex) : regex;
    }

    private static String getRegexFromEqualsNode(TmfFilterEqualsNode filter) {
        return TmfFilterHelper.quote(TmfFilterHelper.getFilterAspectName(filter)) + SPACE + (filter.isNot() ? "!=" : "==") + SPACE + TmfFilterHelper.quote(filter.getValue());
    }

    private static String getRegexFromContainsNode(TmfFilterContainsNode filter) {
        String regex = TmfFilterHelper.quote(TmfFilterHelper.getFilterAspectName(filter)) + " contains " + TmfFilterHelper.quote(filter.getValue());
        return filter.isNot() ? TmfFilterHelper.not(regex) : regex;
    }

    private static String getRegexFromCompareNode(TmfFilterCompareNode filter) {
        String regex = TmfFilterHelper.quote(TmfFilterHelper.getFilterAspectName(filter)) + SPACE + TmfFilterHelper.getCompareSign(filter.getResult()) + SPACE + TmfFilterHelper.quote(filter.getValue());
        return filter.isNot() ? TmfFilterHelper.not(regex) : regex;
    }

    private static String not(String string) {
        return "!(" + string + ")";
    }

    private static String quote(@Nullable String string) {
        if (string == null) {
            throw new NullPointerException("unexpected null string in the filter");
        }
        return QUOTE + string + QUOTE;
    }

    private static String getCompareSign(int result) {
        if (result < 0) {
            return "<";
        }
        if (result == 0) {
            return "==";
        }
        return ">";
    }

    private static String getFilterAspectName(TmfFilterAspectNode filter) {
        int slashPos;
        ITmfEventAspect<?> aspect = filter.getEventAspect();
        if (aspect == TmfBaseAspects.getContentsAspect()) {
            return "*";
        }
        String name = aspect.getName();
        if (aspect instanceof TmfEventFieldAspect) {
            TmfEventFieldAspect eventAspect = (TmfEventFieldAspect)aspect;
            String fieldPath = eventAspect.getFieldPath();
            if (fieldPath != null) {
                name = fieldPath;
            } else if (eventAspect.getName().equals(TmfBaseAspects.getContentsAspect().getName())) {
                return "*";
            }
        }
        return (slashPos = name.lastIndexOf("/")) < 0 ? name : name.substring(slashPos);
    }

    private static String getRegexFromOrNode(TmfFilterOrNode filter) {
        String regex = TmfFilterHelper.joinChildrenRegex(filter, "||");
        return filter.isNot() ? TmfFilterHelper.not(regex) : regex;
    }

    private static String getRegexFromAndNode(TmfFilterAndNode filter) {
        String regex = TmfFilterHelper.joinChildrenRegex(filter, "&&");
        return filter.isNot() ? TmfFilterHelper.not(regex) : regex;
    }

    private static String getRegexFromRootNode(TmfFilterRootNode filter) {
        return TmfFilterHelper.joinChildrenRegex(filter, "&&");
    }

    private static String joinChildrenRegex(TmfFilterTreeNode filter, String joinString) {
        ArrayList<String> regexes = new ArrayList<String>();
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = filter.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode childFilter = iTmfFilterTreeNodeArray[n2];
            String regex = TmfFilterHelper.getRegexFromFilter(childFilter);
            if (!regex.isEmpty()) {
                regexes.add(regex);
            }
            ++n2;
        }
        return Objects.requireNonNull(StringUtils.join(regexes, (String)(SPACE + joinString + SPACE)));
    }
}

