/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.NamedNodeCollector;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMInstanceCache {
    private final HashMap<String, ICPPTemplateInstance> fMap = new HashMap();
    private ICPPDeferredClassInstance fDeferredInstance;

    public static PDOMInstanceCache getCache(PDOMBinding binding) {
        long record;
        Long key;
        PDOM pdom = binding.getPDOM();
        Object cache = pdom.getCachedResult(key = Long.valueOf((record = binding.getRecord()) + 2L));
        if (cache instanceof PDOMInstanceCache) {
            return (PDOMInstanceCache)cache;
        }
        PDOMInstanceCache newCache = new PDOMInstanceCache();
        try {
            newCache.populate(binding);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        newCache = (PDOMInstanceCache)pdom.putCachedResult(key, newCache, false);
        return newCache;
    }

    public final synchronized void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        try {
            String key = IndexCPPSignatureUtil.getTemplateArgString(arguments, true);
            this.fMap.put(key, instance);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }

    public final synchronized ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        try {
            String key = IndexCPPSignatureUtil.getTemplateArgString(arguments, true);
            return this.fMap.get(key);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private void populate(PDOMBinding binding) throws CoreException {
        PDOMNamedNode[] nodes;
        Object parent = binding.getParentNode();
        if (parent == null) {
            parent = binding.getLinkage();
        }
        NamedNodeCollector nn = new NamedNodeCollector((PDOMLinkage)binding.getLinkage(), binding.getNameCharArray());
        ((PDOMNode)parent).accept(nn);
        PDOMNamedNode[] pDOMNamedNodeArray = nodes = nn.getNodes();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateInstance inst;
            PDOMNamedNode node = pDOMNamedNodeArray[n2];
            if (node instanceof ICPPTemplateInstance && binding.equals((inst = (ICPPTemplateInstance)((Object)node)).getTemplateDefinition())) {
                ICPPTemplateArgument[] args = inst.getTemplateArguments();
                this.addInstance(args, inst);
            }
            ++n2;
        }
    }

    public synchronized ICPPTemplateInstance[] getAllInstances() {
        return this.fMap.values().toArray(new ICPPTemplateInstance[this.fMap.size()]);
    }

    public ICPPDeferredClassInstance getDeferredInstance() {
        return this.fDeferredInstance;
    }

    public void putDeferredInstance(ICPPDeferredClassInstance deferredInstance) {
        this.fDeferredInstance = deferredInstance;
    }
}

