/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.ui.IWorkbenchPart;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class PinAndCloneTest {
    private static SWTWorkbenchBot fBot;
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String TRACETYPE_ID = "org.eclipse.linuxtools.lttng2.ust.tracetype";
    private static final String TIME_GRAPH_VIEW_TITLE = "Time Graph Stub";
    private static final String PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE = "Time Graph Stub <context-switches-ust>";
    private static final String PINNED_TO_KERNEL_TIME_GRAPH_VIEW_TITLE = "Time Graph Stub <context-switches-kernel>";
    private static final String PIN_VIEW_BUTTON_NAME = "Pin View";
    private static final String UNPIN_VIEW_BUTTON_NAME = "Unpin View";
    private static final String PIN_TO_PREFIX = "Pin to ";
    private static final String NEW_VIEW_MENU = "New Time Graph Stub view";
    private static final String PINNED_TO_PREFIX = "pinned to ";
    private static final String CLONED_TRACE_SUFFIX = " | 2";
    private static final String FOLLOW_TIME_UPDATES_FROM_OTHER_TRACES = "Follow time updates from other traces";
    private static final int SECOND = 1000000000;
    private static final long UST_START = 1450193697034689597L;
    private static final long UST_END = 1450193745774189602L;
    private static final @NonNull TmfTimeRange RANGE;
    private static final @NonNull TmfTimeRange INITIAL_UST_RANGE;
    private static final @NonNull String PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE2 = "Time Graph Stub <context-switches-ust | 2>";
    private SWTBotView fOriginalViewBot;
    private CtfTmfTrace fUstTestTrace;

    static {
        RANGE = new TmfTimeRange(TmfTimestamp.fromNanos((long)1450193698034689597L), TmfTimestamp.fromNanos((long)1450193699034689597L));
        INITIAL_UST_RANGE = new TmfTimeRange(TmfTimestamp.fromNanos((long)1450193697034689597L), TmfTimestamp.fromNanos((long)1450193697134689597L));
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void tearDown() {
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
    }

    @Before
    public void setup() {
        this.fUstTestTrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.CONTEXT_SWITCHES_UST);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, this.fUstTestTrace.getPath(), TRACETYPE_ID);
        SWTBotUtils.activateEditor(fBot, this.fUstTestTrace.getName());
        SWTBotUtils.openView("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub");
        this.fOriginalViewBot = fBot.viewById("org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.timegraph.stub");
        this.fOriginalViewBot.show();
    }

    @After
    public void after() {
        fBot.closeAllEditors();
        SWTBotUtils.closeSecondaryShells(fBot);
        this.fUstTestTrace.dispose();
    }

    @Test
    public void testPinSingleTrace() {
        Assert.assertEquals((Object)TIME_GRAPH_VIEW_TITLE, (Object)this.fOriginalViewBot.getTitle());
        fBot.waitUntil((ICondition)new DefaultCondition(){
            WidgetNotFoundException fException;

            public boolean test() throws Exception {
                try {
                    SWTBotToolbarDropDownButton toolbarDropDownButton = PinAndCloneTest.this.fOriginalViewBot.toolbarDropDownButton(PinAndCloneTest.PIN_VIEW_BUTTON_NAME);
                    toolbarDropDownButton.menuItem(PinAndCloneTest.PIN_TO_PREFIX + PinAndCloneTest.this.fUstTestTrace.getName()).click();
                    return true;
                }
                catch (WidgetNotFoundException e) {
                    this.fException = e;
                    return false;
                }
            }

            public String getFailureMessage() {
                return "Traces not available in toolbar drop down menu: " + String.valueOf((Object)this.fException);
            }
        });
        this.assertOriginalViewTitle(PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE);
        this.fOriginalViewBot.toolbarButton(UNPIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(TIME_GRAPH_VIEW_TITLE);
        this.fOriginalViewBot.toolbarButton(PIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE);
    }

    private void assertOriginalViewTitle(String newName) {
        Widget expectedWidget = this.fOriginalViewBot.getWidget();
        Assert.assertNotNull((Object)expectedWidget);
        SWTBotView actualView = fBot.viewByTitle(newName);
        Widget actualWidget = actualView.getWidget();
        Assert.assertNotNull((Object)actualWidget);
        Assert.assertEquals((Object)expectedWidget, (Object)actualWidget);
    }

    @Ignore
    @Test
    public void testPinTwoTraces() {
        ITmfTrace ust = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)ust);
        CtfTmfTrace kernelTestTrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.CONTEXT_SWITCHES_KERNEL);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, kernelTestTrace.getPath(), TRACETYPE_ID);
        WaitUtils.waitForJobs();
        SWTBotEditor kernelEditor = SWTBotUtils.activateEditor(fBot, kernelTestTrace.getName());
        fBot.editorByTitle(kernelTestTrace.getName());
        fBot.waitUntil((ICondition)new DefaultCondition((ITmfTrace)kernelTestTrace){
            WidgetNotFoundException fException;
            private final /* synthetic */ ITmfTrace val$kernelTestTrace;
            {
                this.val$kernelTestTrace = iTmfTrace;
            }

            public boolean test() throws Exception {
                try {
                    SWTBotToolbarDropDownButton toolbarDropDownButton = PinAndCloneTest.this.fOriginalViewBot.toolbarDropDownButton(PinAndCloneTest.PIN_VIEW_BUTTON_NAME);
                    toolbarDropDownButton.menuItem(PinAndCloneTest.PIN_TO_PREFIX + this.val$kernelTestTrace.getName());
                    toolbarDropDownButton.menuItem(PinAndCloneTest.PIN_TO_PREFIX + PinAndCloneTest.this.fUstTestTrace.getName()).click();
                    return true;
                }
                catch (WidgetNotFoundException e) {
                    this.fException = e;
                    return false;
                }
            }

            public String getFailureMessage() {
                return "Traces not available in toolbar drop down menu: " + String.valueOf((Object)this.fException);
            }
        });
        this.assertOriginalViewTitle(PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE);
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((String)"There should be an active trace", (Object)activeTrace);
        Assert.assertEquals((String)"context-switches-kernel should be the active trace", (Object)kernelTestTrace.getName(), (Object)activeTrace.getName());
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        ITmfTrace kernelTrace = traceManager.getActiveTrace();
        Assert.assertNotNull((Object)kernelTrace);
        SWTBotUtils.activateEditor(fBot, this.fUstTestTrace.getName());
        this.assertOriginalViewTitle(PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE);
        SWTBotUtils.activateEditor(fBot, kernelTestTrace.getName());
        this.assertOriginalViewTitle(PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE);
        IWorkbenchPart part = this.fOriginalViewBot.getViewReference().getPart(false);
        Assert.assertTrue((boolean)(part instanceof AbstractTimeGraphView));
        AbstractTimeGraphView abstractTimeGraphView = (AbstractTimeGraphView)part;
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, RANGE, kernelTrace));
        SWTBotUtils.activateEditor(fBot, this.fUstTestTrace.getName());
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition(abstractTimeGraphView, ust, INITIAL_UST_RANGE));
        SWTBotUtils.activateEditor(fBot, kernelTrace.getName());
        this.fOriginalViewBot.toolbarButton(UNPIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(TIME_GRAPH_VIEW_TITLE);
        this.fOriginalViewBot.toolbarButton(PIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(PINNED_TO_KERNEL_TIME_GRAPH_VIEW_TITLE);
        SWTBotTable kernelEventTable = kernelEditor.bot().table();
        SWTBotTableItem kernelEvent = kernelEventTable.getTableItem(5);
        kernelEvent.contextMenu(FOLLOW_TIME_UPDATES_FROM_OTHER_TRACES).click();
        TmfTimeRange expectedUstWindowRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)1450193698034689597L), TmfTimestamp.fromNanos((long)1450193744774189602L));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, expectedUstWindowRange, ust));
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition(abstractTimeGraphView, kernelTrace, expectedUstWindowRange));
        SWTBotEditor kernelTable = fBot.editorByTitle(kernelTestTrace.getName());
        kernelTable.close();
        this.assertOriginalViewTitle(TIME_GRAPH_VIEW_TITLE);
        kernelTestTrace.dispose();
    }

    @Test
    public void testCloneSingleTrace() {
        SWTBotMenu cloneMenu = this.fOriginalViewBot.viewMenu().menu(new String[]{NEW_VIEW_MENU});
        cloneMenu.menu(PINNED_TO_PREFIX + this.fUstTestTrace.getName()).click();
        this.assertOriginalViewTitle(TIME_GRAPH_VIEW_TITLE);
        SWTBotView clonedView = fBot.viewByTitle(PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE);
        Assert.assertEquals((String)"Should not have created a new instance", (long)1L, (long)fBot.editors().size());
        clonedView.close();
        cloneMenu.menu(PINNED_TO_PREFIX + this.fUstTestTrace.getName() + " | new instance").click();
        this.assertOriginalViewTitle(TIME_GRAPH_VIEW_TITLE);
        clonedView = fBot.viewByTitle(PINNED_TO_UST_TIME_GRAPH_VIEW_TITLE2);
        Assert.assertEquals((String)"Should have created a new instance", (long)2L, (long)fBot.editors().size());
        SWTBotEditor cloneEditor = fBot.editorByTitle(this.fUstTestTrace.getName() + CLONED_TRACE_SUFFIX);
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        ITmfTrace cloneTrace = traceManager.getActiveTrace();
        Assert.assertNotNull((Object)cloneTrace);
        SWTBotUtils.activateEditor(fBot, this.fUstTestTrace.getName());
        this.fOriginalViewBot.toolbarButton(PIN_VIEW_BUTTON_NAME).click();
        ITmfTrace ust = traceManager.getActiveTrace();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, RANGE, ust));
        SWTBotUtils.activateEditor(fBot, cloneTrace.getName() + CLONED_TRACE_SUFFIX);
        IWorkbenchPart part = clonedView.getViewReference().getPart(false);
        Assert.assertTrue((boolean)(part instanceof AbstractTimeGraphView));
        AbstractTimeGraphView abstractTimeGraphView = (AbstractTimeGraphView)part;
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition(abstractTimeGraphView, cloneTrace, INITIAL_UST_RANGE));
        cloneEditor.close();
    }

    @Test
    public void testFollow() {
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        ITmfTrace ust = traceManager.getActiveTrace();
        Assert.assertNotNull((Object)ust);
        CtfTmfTrace kernelTest = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.CONTEXT_SWITCHES_KERNEL);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, kernelTest.getPath(), TRACETYPE_ID);
        WaitUtils.waitForJobs();
        SWTBotEditor kernelEditor = SWTBotUtils.activateEditor(fBot, kernelTest.getName());
        fBot.editorByTitle(kernelTest.getName());
        ITmfTrace kernel = traceManager.getActiveTrace();
        Assert.assertNotNull((Object)kernel);
        SWTBotTable kernelEventTable = kernelEditor.bot().table();
        SWTBotTableItem kernelEvent = kernelEventTable.getTableItem(5);
        kernelEvent.contextMenu(FOLLOW_TIME_UPDATES_FROM_OTHER_TRACES).click();
        SWTBotUtils.activateEditor(fBot, ust.getName());
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, RANGE, ust));
        IWorkbenchPart part = this.fOriginalViewBot.getViewReference().getPart(false);
        Assert.assertTrue((boolean)(part instanceof AbstractTimeGraphView));
        AbstractTimeGraphView abstractTimeGraphView = (AbstractTimeGraphView)part;
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition(abstractTimeGraphView, ust, RANGE));
        SWTBotUtils.activateEditor(fBot, kernel.getName());
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition(abstractTimeGraphView, kernel, RANGE));
        kernelEventTable.contextMenu(FOLLOW_TIME_UPDATES_FROM_OTHER_TRACES).click();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, ust.getInitialTimeRange(), ust));
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition(abstractTimeGraphView, kernel, RANGE));
        kernelTest.dispose();
    }
}

