/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.analysis.requirements;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventRequirement;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AnalysisEventRequirementTest {
    private static final @NonNull String EVENT1 = "abc";
    private static final @NonNull String EVENT2 = "def";
    private static final @NonNull String EVENT3 = "ghi";
    private final @NonNull TmfTrace fTrace = new TraceWithEvents();

    @After
    public void cleanup() {
        this.fTrace.dispose();
    }

    @Test
    public void testOptionalRequirements() {
        TmfAnalysisEventRequirement req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1));
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT3));
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT3));
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
    }

    @Test
    public void testMandatoryRequirements() {
        TmfAnalysisEventRequirement req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT2), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT2, (Object)EVENT3), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT3), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertFalse((boolean)req.test((Object)this.fTrace));
    }

    @Test
    public void testAtLeastOneRequirements() {
        TmfAnalysisEventRequirement req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT2), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT2, (Object)EVENT3), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT3), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        Assert.assertFalse((boolean)req.test((Object)this.fTrace));
    }

    @Test
    public void testAllOrNothingRequirements() {
        TmfAnalysisEventRequirement req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT2), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT2, (Object)EVENT3), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertFalse((boolean)req.test((Object)this.fTrace));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT3), TmfAbstractAnalysisRequirement.PriorityLevel.ALL_OR_NOTHING);
        Assert.assertTrue((boolean)req.test((Object)this.fTrace));
    }

    @Test
    public void testNoPreDefinedEvents() {
        TmfTraceStub traceNoEvents = new TmfTraceStub();
        TmfAnalysisEventRequirement req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT3), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        Assert.assertTrue((boolean)req.test((Object)traceNoEvents));
        req = new TmfAnalysisEventRequirement((Collection)ImmutableSet.of((Object)EVENT1, (Object)EVENT2), TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
        Assert.assertTrue((boolean)req.test((Object)traceNoEvents));
        traceNoEvents.dispose();
    }

    private static class TraceWithEvents
    extends TmfTraceStub
    implements ITmfTraceWithPreDefinedEvents {
        private TraceWithEvents() {
        }

        public @NonNull Set<? extends @NonNull ITmfEventType> getContainedEventTypes() {
            return ImmutableSet.of((Object)new ITmfEventType(){

                public @NonNull String getName() {
                    return AnalysisEventRequirementTest.EVENT1;
                }

                public ITmfEventField getRootField() {
                    return null;
                }

                public Collection<String> getFieldNames() {
                    return null;
                }
            }, (Object)new ITmfEventType(){

                public @NonNull String getName() {
                    return AnalysisEventRequirementTest.EVENT2;
                }

                public ITmfEventField getRootField() {
                    return null;
                }

                public Collection<String> getFieldNames() {
                    return null;
                }
            });
        }
    }
}

