/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.perf.callstack;

import java.util.Arrays;
import org.eclipse.tracecompass.analysis.profiling.core.tests.perf.CallStackAndGraphBenchmark;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfBenchmarkTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LttngUstCallstackBenchmark
extends CallStackAndGraphBenchmark {
    private final String fTestTrace;

    private static String getPathFromCtfTestTrace(CtfTestTrace testTrace) {
        CtfTmfTrace ctftrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace);
        String path = ctftrace.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Path shouldn't be null");
        }
        ctftrace.dispose();
        return path;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({CtfTestTrace.CYG_PROFILE.name(), LttngUstCallstackBenchmark.getPathFromCtfTestTrace(CtfTestTrace.CYG_PROFILE)}, {CtfBenchmarkTrace.UST_QMLSCENE.name(), CtfBenchmarkTrace.UST_QMLSCENE.getTracePath().toString()});
    }

    public LttngUstCallstackBenchmark(String name, String tracePath) {
        super(name, "org.eclipse.tracecompass.lttng2.ust.core.analysis.callstack");
        this.fTestTrace = tracePath;
    }

    protected TmfTrace getTrace() throws TmfTraceException {
        LttngUstTrace trace = new LttngUstTrace();
        trace.initTrace(null, this.fTestTrace, ITmfEvent.class);
        return trace;
    }
}

