/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.event.matching;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpEventMatching;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.event.matching.TcpLttngEventMatching;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.BeforeClass;
import org.junit.Test;

public class EventMatchingBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#Event matching#";
    private static final String TIME = " (time)";
    private static final String MEMORY = " (memory usage)";
    private static final String TEST_SUMMARY = "Event matching";

    @BeforeClass
    public static void setUp() {
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpEventMatching());
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new TcpLttngEventMatching());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSmallTraces() {
        CtfTmfTrace trace1 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_SRC);
        CtfTmfTrace trace2 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.SYNC_DEST);
        @NonNull ImmutableSet traces = ImmutableSet.of((Object)trace1, (Object)trace2);
        EventMatchingBenchmark.runCpuTest((Set<ITmfTrace>)traces, "Match TCP events", 100);
        trace1.dispose();
        trace2.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDjangoTraces() {
        CtfTmfTrace trace1 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_CLIENT);
        CtfTmfTrace trace2 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_DB);
        CtfTmfTrace trace3 = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.DJANGO_HTTPD);
        @NonNull ImmutableSet traces = ImmutableSet.of((Object)trace1, (Object)trace2, (Object)trace3);
        EventMatchingBenchmark.runCpuTest((Set<ITmfTrace>)traces, "Django traces", 10);
        EventMatchingBenchmark.runMemoryTest((Set<ITmfTrace>)traces, "Django traces", 10);
        trace1.dispose();
        trace2.dispose();
        trace3.dispose();
    }

    private static void runCpuTest(Set<@NonNull ITmfTrace> testTraces, String testName, int loop_count) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + TIME);
        perf.tagAsSummary(pm, "Event matching:" + testName + TIME, Dimension.CPU_TIME);
        int i = 0;
        while (i < loop_count) {
            TmfEventMatching traceMatch = new TmfEventMatching(testTraces);
            pm.start();
            traceMatch.matchEvents();
            pm.stop();
            ++i;
        }
        pm.commit();
    }

    private static void runMemoryTest(Set<@NonNull ITmfTrace> testTraces, String testName, int loop_count) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + MEMORY);
        perf.tagAsSummary(pm, "Event matching:" + testName + MEMORY, Dimension.USED_JAVA_HEAP);
        int i = 0;
        while (i < loop_count) {
            TmfEventMatching traceMatch = new TmfEventMatching(testTraces);
            System.gc();
            pm.start();
            traceMatch.matchEvents();
            System.gc();
            pm.stop();
            ++i;
        }
        pm.commit();
    }
}

