/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DecimalUnitFormatFactorTest {
    private final @NonNull Format fFormat;
    private final @NonNull Number fNumValue;
    private final @NonNull String fExpected;

    public DecimalUnitFormatFactorTest(@NonNull Number value, @NonNull String expected, @NonNull Double factor) {
        this.fNumValue = value;
        this.fExpected = expected;
        this.fFormat = new DecimalUnitFormat(factor.doubleValue());
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({0, "0", 10.0}, {3, "300", 100.0}, {975, "97.5", 0.1}, {1000, "1 k", 1.0}, {4000, "40", 0.01}, {-4000, "-40", 0.01}, {-0.04, "-4", 100.0}, {0.002, "20", 10000.0}, {0.0555, "5.5 k", 100000.0}, {4.928373928E-4, "49.3 n", 1.0E-4}, {2.51E-7, "251 p", 0.001}, {Double.POSITIVE_INFINITY, "\u221e", 0.001}, {Double.MAX_VALUE, "4", Double.MIN_NORMAL});
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((String)"format value", (Object)this.fExpected, (Object)this.fFormat.format(this.fNumValue));
    }
}

