/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.SelectionConverter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;

public class DOMSelectionConverterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{SelectionConverter.class};
    private static final Object selectionConverter = new XMLSelectionConverter();

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof IDOMModel && SelectionConverter.class.equals(adapterType)) {
            return (T)selectionConverter;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public static class XMLSelectionConverter
    extends SelectionConverter {
        public Object[] getElements(IStructuredModel model, int start, int end) {
            IDOMNode node;
            NamedNodeMap attributes;
            Object[] objects;
            IDOMNode region;
            Object[] localSelectedStructures = null;
            if (model != null && (region = (IDOMNode)model.getIndexedRegion(start)) != null) {
                if (end <= region.getEndOffset()) {
                    localSelectedStructures = new Object[]{region};
                } else {
                    ArrayList<IDOMNode> structures = new ArrayList<IDOMNode>(2);
                    IDOMNode node2 = region;
                    while (node2 != null) {
                        structures.add(node2);
                        IDOMNode next = (IDOMNode)node2.getNextSibling();
                        if (next == null) {
                            next = (IDOMNode)node2.getParentNode();
                        }
                        if (next != null && next.getEndOffset() > end) break;
                        node2 = next;
                    }
                    localSelectedStructures = structures.toArray();
                }
            }
            if (localSelectedStructures == null) {
                localSelectedStructures = new Object[]{};
            }
            if ((objects = localSelectedStructures).length == 1 && objects[0] instanceof IDOMNode && (attributes = (node = (IDOMNode)objects[0]).getAttributes()) != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    IDOMAttr attribute = (IDOMAttr)attributes.item(i);
                    if (attribute.contains(start) && attribute.contains(end)) {
                        objects[0] = attribute;
                        break;
                    }
                    ++i;
                }
            }
            return objects;
        }

        IRegion getNameRegion(ITextRegionCollection collection) {
            ITextRegionList regions = collection.getRegions();
            int count = collection.getNumberOfRegions();
            int i = 0;
            while (i < count) {
                ITextRegion region = regions.get(i);
                if ("XML_TAG_NAME".equals(region.getType())) {
                    return new Region(collection.getStartOffset(region), region.getTextLength());
                }
                if ("XML_DOCTYPE_NAME".equals(region.getType())) {
                    return new Region(collection.getStartOffset(region), region.getTextLength());
                }
                if ("XML_ELEMENT_DECL_NAME".equals(region.getType())) {
                    return new Region(collection.getStartOffset(region), region.getTextLength());
                }
                if ("XML_ATTLIST_DECL_NAME".equals(region.getType())) {
                    return new Region(collection.getStartOffset(region), region.getTextLength());
                }
                if ("XML_COMMENT_TEXT".equals(region.getType())) {
                    String commented = collection.getText(region);
                    int inset = 0;
                    while (inset < region.getTextLength() && Character.isWhitespace(commented.charAt(inset))) {
                        ++inset;
                    }
                    return new Region(collection.getStartOffset(region) + inset, 0);
                }
                ++i;
            }
            return null;
        }

        public IRegion getSelectionRegion(Object o) {
            if (o instanceof IDOMNode) {
                IDOMNode domNode = (IDOMNode)o;
                IStructuredDocumentRegion documentRegion = domNode.getFirstStructuredDocumentRegion();
                if (documentRegion == null) {
                    return new Region(domNode.getStartOffset(), domNode.getLength());
                }
                IRegion nameRegion = this.getNameRegion((ITextRegionCollection)documentRegion);
                if (nameRegion != null) {
                    return nameRegion;
                }
            }
            return super.getSelectionRegion(o);
        }
    }
}

