/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmEventLayout;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.ApiEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.IRocmEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.OperationEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RocmCallStackStateProvider
extends AbstractTmfStateProvider {
    private static final String ID = "org.eclipse.tracecompass.incubator.rocm.core.stateprovider.atomic";
    public static final String ROOT = "root";
    public static final String NAME = "name";
    public static final String CORRELATION_ID = "correlation_id";
    public static final String HIP_OPERATION_QUEUES = "hip_operation_queues";
    private final RocmEventLayout fLayout;
    private IRocmEventHandler fApiEventHandler;
    private IRocmEventHandler fOperationEventHandler;

    public RocmCallStackStateProvider(ITmfTrace trace, RocmEventLayout layout) {
        super(trace, ID);
        this.fLayout = layout;
        this.fApiEventHandler = new ApiEventHandler();
        this.fOperationEventHandler = new OperationEventHandler();
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new RocmCallStackStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(ITmfEvent event) {
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        if (event.getName().equals(this.fLayout.getHsaOperationBegin()) || event.getName().equals(this.fLayout.getHsaOperationEnd())) {
            this.fOperationEventHandler.handleEvent(event, ssb, this.fLayout);
        } else if (event.getName().equals(this.fLayout.getHipOperationBegin()) || event.getName().equals(this.fLayout.getHipOperationEnd())) {
            this.fOperationEventHandler.handleEvent(event, ssb, this.fLayout);
        } else if (event.getName().startsWith(this.fLayout.getHipPrefix()) || event.getName().startsWith(this.fLayout.getHsaPrefix())) {
            this.fApiEventHandler.handleEvent(event, ssb, this.fLayout);
        }
    }
}

