/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.type;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartType;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.tmf.chart.ui.type.IChartTypeDefinition;

public class ScatterChartTypeDefinition
implements IChartTypeDefinition {
    private static final String SCATTER_CHART_ICON = "icons/scatterchart.png";

    @Override
    public ChartType getType() {
        return ChartType.SCATTER_CHART;
    }

    @Override
    public ImageData getImageData() {
        return new ImageData(this.getClass().getClassLoader().getResourceAsStream(SCATTER_CHART_ICON));
    }

    @Override
    public boolean checkIfXDescriptorValid(IDataChartDescriptor<?, ?> desc, @Nullable IDataChartDescriptor<?, ?> filter) {
        return IChartTypeDefinition.filterSameDescriptor(desc, filter);
    }

    @Override
    public boolean checkIfYDescriptorValid(IDataChartDescriptor<?, ?> desc, @Nullable IDataChartDescriptor<?, ?> filter) {
        return IChartTypeDefinition.filterSameDescriptor(desc, filter);
    }

    @Override
    public boolean checkIfXLogscalePossible(@Nullable IDataChartDescriptor<?, ?> filter) {
        return ScatterChartTypeDefinition.checkNumericalNotTimestamp(filter);
    }

    @Override
    public boolean checkIfYLogscalePossible(@Nullable IDataChartDescriptor<?, ?> filter) {
        return ScatterChartTypeDefinition.checkNumericalNotTimestamp(filter);
    }

    private static boolean checkNumericalNotTimestamp(@Nullable IDataChartDescriptor<?, ?> filter) {
        if (filter == null) {
            return true;
        }
        return IChartTypeDefinition.checkIfNumerical(filter) && !IChartTypeDefinition.checkIfTimestamp(filter);
    }
}

