/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.Activator;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SoftIrqExitHandler
extends VMKernelEventHandler {
    public SoftIrqExitHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        FusedVirtualMachineStateProvider sp = this.getStateProvider();
        VirtualMachine host = sp.getCurrentMachine(event);
        VirtualCPU cpuObject = VirtualCPU.getVirtualCPU(host, cpu.longValue());
        if (host != null && host.isGuest()) {
            Integer physicalCPU = sp.getPhysicalCPU(host, cpu);
            if (physicalCPU != null) {
                cpu = physicalCPU;
            } else {
                return;
            }
        }
        int currentCPUNode = FusedVMEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        Integer softIrqId = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldVec()}).getValue()).intValue();
        int currentThreadNode = FusedVMEventHandlerUtils.getCurrentThreadNode(cpu, ss);
        int quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeSoftIRQs(cpu, ss), new String[]{softIrqId.toString()});
        long timestamp = FusedVMEventHandlerUtils.getTimestamp(event);
        if (SoftIrqExitHandler.isSoftIrqRaised(ss.queryOngoing(quark))) {
            ss.modifyAttribute(timestamp, (Object)1, quark);
        } else {
            ss.modifyAttribute(timestamp, null, quark);
        }
        List softIrqs = ss.getSubAttributes(ss.getParentAttributeQuark(quark), false);
        for (Integer softIrq : softIrqs) {
            Object irqStateValue = ss.queryOngoing(softIrq.intValue());
            if (irqStateValue == null) continue;
            return;
        }
        boolean modify = true;
        if (host != null) {
            int machineNameQuark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Machine_name"});
            try {
                modify = ss.querySingleState(timestamp, machineNameQuark).getStateValue().unboxStr().equals(host.getHostId());
            }
            catch (StateSystemDisposedException e) {
                Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            }
        }
        FusedVMEventHandlerUtils.setProcessToRunning(timestamp, currentThreadNode, ss);
        quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
        Integer value = cpuObject.getStateBeforeIRQ();
        cpuObject.setCurrentState(value);
        if (modify) {
            ss.modifyAttribute(timestamp, (Object)value, quark);
        }
    }

    private static boolean isSoftIrqRaised(@Nullable Object state) {
        return state instanceof Integer && ((Integer)state & 1) == 1;
    }
}

