/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow;

public class TargetMessageInfo {
    private final String fNode;
    private final String fTopic;
    private final RosQueueType fQueueType;
    private final int fQueuePosition;
    private final long fMsgRef;
    private final long fSelectedTimestamp;
    private final long fMsgTimestamp;

    public TargetMessageInfo(String node, String topic, RosQueueType queueType, int queuePosition, String msgRef, long selectedTimestamp, long msgTimestamp) {
        this.fNode = node;
        this.fTopic = topic;
        this.fQueueType = queueType;
        this.fQueuePosition = queuePosition;
        this.fMsgRef = Long.decode(msgRef);
        this.fSelectedTimestamp = selectedTimestamp;
        this.fMsgTimestamp = msgTimestamp;
    }

    public String getNode() {
        return this.fNode;
    }

    public String getTopic() {
        return this.fTopic;
    }

    public RosQueueType getQueueType() {
        return this.fQueueType;
    }

    public int getQueuePosition() {
        return this.fQueuePosition;
    }

    public long getMsgRef() {
        return this.fMsgRef;
    }

    public long getSelectedTimestamp() {
        return this.fSelectedTimestamp;
    }

    public long getMsgTimestamp() {
        return this.fMsgTimestamp;
    }

    public String toString() {
        return "TargetMessageInfo: " + this.fNode + ", " + this.fTopic + "(" + this.fQueueType.name() + "):0x" + Long.toHexString(this.fMsgRef) + " @ " + this.fQueuePosition + ", " + this.fMsgTimestamp + " | " + this.fSelectedTimestamp;
    }

    public static enum RosQueueType {
        SUB,
        PUB;

    }
}

