/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis;

import java.util.Objects;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.Activator;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.lcore.analysis.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;

public class LogicalCore {
    private static final String LCORES = "LCores";
    private static final String LCORE_FUNCTION = "LCORE_FUNCTION";
    private static final String LCORE_ROLE = "LCORE_ROLE";
    private static final String LCORE_STATUS = "LCORE_STATUS";
    private static final String SERVICES = "Services";
    private static final String SERVICE_CORE = "service_core";
    private static final String SERVICE_NAME = "service_name";
    private static final String SERVICE_STATUS = "service_status";

    public static void setRole(ITmfStateSystemBuilder ssb, LogicalCoreRole newRole, int lcoreId, long timestamp) {
        if (newRole != LogicalCoreRole.ROLE_SERVICE) {
            LogicalCoreStatus newStatus;
            if (newRole == LogicalCoreRole.ROLE_RTE) {
                newStatus = LogicalCoreStatus.IDLE;
            } else if (newRole == LogicalCoreRole.ROLE_OFF || newRole == LogicalCoreRole.ROLE_NON_EAL) {
                newStatus = LogicalCoreStatus.UNKNOWN;
            } else {
                Activator.getInstance().logWarning("LogicalCore setRole with unexpected role value!");
                newStatus = LogicalCoreStatus.UNKNOWN;
            }
            LogicalCore.setStatus(ssb, newStatus, lcoreId, timestamp);
        }
        int lcoreQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{LCORES, String.valueOf(lcoreId)});
        int lcoreRoleQuark = ssb.getQuarkRelativeAndAdd(lcoreQuark, new String[]{LCORE_ROLE});
        ssb.modifyAttribute(timestamp, (Object)newRole.getLabel(), lcoreRoleQuark);
    }

    public static void setStatus(ITmfStateSystemBuilder ssb, LogicalCoreStatus newStatus, Integer lcoreId, long timestamp) {
        int lcoreQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{LCORES, String.valueOf(lcoreId)});
        int lcoreRoleQuark = ssb.getQuarkRelativeAndAdd(lcoreQuark, new String[]{LCORE_STATUS});
        ssb.modifyAttribute(timestamp, (Object)newStatus.getLabel(), lcoreRoleQuark);
    }

    public static void setFunction(ITmfStateSystemBuilder ssb, Long function, Integer lcoreId, long timestamp) {
        int lcoreQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{LCORES, String.valueOf(lcoreId)});
        int lcoreFuncQuark = ssb.getQuarkRelativeAndAdd(lcoreQuark, new String[]{LCORE_FUNCTION});
        ssb.modifyAttribute(timestamp, (Object)Long.toHexString(function), lcoreFuncQuark);
    }

    private static int getServiceQuark(ITmfStateSystemBuilder ssb, Integer serviceId) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{SERVICES, String.valueOf(serviceId)});
    }

    public static void setServiceLcore(ITmfStateSystemBuilder ssb, Integer lcoreId, Integer serviceId, long timestamp) {
        int serviceLcoreQuark = ssb.getQuarkRelativeAndAdd(LogicalCore.getServiceQuark(ssb, serviceId), new String[]{SERVICE_CORE});
        ssb.modifyAttribute(timestamp, (Object)String.valueOf(lcoreId), serviceLcoreQuark);
    }

    public static void setServiceName(ITmfStateSystemBuilder ssb, String serviceName, Integer serviceId, long timestamp) {
        int serviceNameQuark = ssb.getQuarkRelativeAndAdd(LogicalCore.getServiceQuark(ssb, serviceId), new String[]{SERVICE_NAME});
        ssb.modifyAttribute(timestamp, (Object)serviceName, serviceNameQuark);
    }

    public static void setServiceStatus(ITmfStateSystemBuilder ssb, ServiceStatus serviceStatus, Integer serviceId, long timestamp) {
        int serviceStatusQuark = ssb.getQuarkRelativeAndAdd(LogicalCore.getServiceQuark(ssb, serviceId), new String[]{SERVICE_STATUS});
        ssb.modifyAttribute(timestamp, (Object)serviceStatus.toString(), serviceStatusQuark);
    }

    static enum LogicalCoreRole {
        ROLE_RTE(String.valueOf(Messages.LCoreRole_rte)),
        ROLE_OFF(String.valueOf(Messages.LCoreRole_off)),
        ROLE_SERVICE(String.valueOf(Messages.LCoreRole_service)),
        ROLE_NON_EAL(String.valueOf(Messages.LCoreRole_non_eal)),
        ROLE_UNKNOWN(String.valueOf(Messages.LCoreRole_unknown));

        private final String fLabel;

        private LogicalCoreRole(String label) {
            this.fLabel = label;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public static LogicalCoreRole fromInt(int value) {
            LogicalCoreRole[] roles = LogicalCoreRole.values();
            if (value < 0 || value >= roles.length) {
                return ROLE_UNKNOWN;
            }
            return Objects.requireNonNull(roles[value]);
        }
    }

    static enum LogicalCoreStatus {
        IDLE(String.valueOf(Messages.LCoreStatus_idle)),
        RUNNING(String.valueOf(Messages.LCoreStatus_running)),
        UNKNOWN(String.valueOf(Messages.LCoreStatus_unknown));

        private final String fLabel;

        private LogicalCoreStatus(String label) {
            this.fLabel = label;
        }

        public String getLabel() {
            return this.fLabel;
        }
    }

    static enum ServiceStatus {
        REGISTERED(String.valueOf(Messages.ServiceStatus_registered)),
        DISABLED(String.valueOf(Messages.ServiceStatus_disabled)),
        ENABLED(String.valueOf(Messages.ServiceStatus_enabled)),
        PENDING(String.valueOf(Messages.ServiceStatus_pending)),
        RUNNING(String.valueOf(Messages.ServiceStatus_running)),
        UNKNOWN(String.valueOf(Messages.ServiceStatus_unknown));

        private final String fLabel;

        private ServiceStatus(String label) {
            this.fLabel = label;
        }

        public String getLabel() {
            return this.fLabel;
        }
    }
}

