/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.util.ScriptLanguageKeys;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLContentAssistUtilities
extends ContentAssistUtils {
    public static final String CONTENT = "Content";
    public static final String CONTENT_SCRIPT_TYPE = "Content-Script-Type";
    public static final String HEAD = "HEAD";
    public static final String HTML = "HTML";
    public static final String HTTP_EQUIV = "HTTP-EQUIV";
    public static final String META = "META";

    public static ICompletionProposal computeJSPEndTagProposal(ITextViewer viewer, int documentPosition, IndexedRegion indexedNode, String parentTagName, String imagePath) {
        String proposedText;
        CustomCompletionProposal p = null;
        boolean hasEndTag = true;
        boolean isJSPTag = false;
        IDOMNode xnode = null;
        String tagName = "";
        if (indexedNode instanceof IDOMNode) {
            xnode = (IDOMNode)indexedNode;
            if (xnode.getEndStructuredDocumentRegion() != null) {
                return null;
            }
            IDOMNode openNode = null;
            if (!xnode.getNodeName().equalsIgnoreCase(parentTagName)) {
                openNode = (IDOMNode)xnode.getParentNode();
            }
            if (openNode != null) {
                if (openNode instanceof IDOMElement) {
                    isJSPTag = ((IDOMElement)openNode).isJSPTag();
                }
                tagName = openNode.getNodeName();
                boolean bl = hasEndTag = openNode.getEndStructuredDocumentRegion() != null;
            }
        }
        if (!hasEndTag && !isJSPTag) {
            proposedText = "</" + tagName;
            String viewerText = viewer.getTextWidget().getText();
            if (viewerText.length() >= documentPosition && viewerText.length() >= 2 && documentPosition >= 2) {
                String last2chars = viewerText.substring(documentPosition - 2, documentPosition);
                if (last2chars.endsWith("</")) {
                    proposedText = tagName;
                } else if (last2chars.endsWith("<")) {
                    proposedText = "/" + tagName;
                }
            }
            p = new CustomCompletionProposal(String.valueOf(proposedText) + ">", documentPosition, 0, proposedText.length() + 1, XMLEditorPluginImageHelper.getInstance().getImage(imagePath), NLS.bind((String)XMLUIMessages.End_with_, (Object[])new Object[]{proposedText}), null, null, 1400);
        } else if (!hasEndTag && isJSPTag) {
            proposedText = "%";
            String viewerText = viewer.getTextWidget().getText();
            if (viewerText.length() >= documentPosition && viewerText.length() >= 2) {
                String last2chars = viewerText.substring(documentPosition - 2, documentPosition);
                String lastchar = viewerText.substring(documentPosition - 1, documentPosition);
                if (lastchar.equals("%")) {
                    proposedText = last2chars.endsWith("<%") ? "%" : "";
                }
            }
            p = new CustomCompletionProposal(String.valueOf(proposedText) + ">", documentPosition, 0, proposedText.length() + 1, XMLEditorPluginImageHelper.getInstance().getImage(imagePath), NLS.bind((String)XMLUIMessages.End_with_, (Object[])new Object[]{proposedText}), null, null, 1400);
        }
        return p;
    }

    public static ICompletionProposal computeXMLEndTagProposal(ITextViewer viewer, int documentPosition, IndexedRegion indexedNode, String parentTagName, String imagePath) {
        CustomCompletionProposal p = null;
        boolean hasEndTag = true;
        IDOMNode xnode = null;
        String tagName = "";
        if (indexedNode instanceof IDOMNode) {
            xnode = (IDOMNode)indexedNode;
            if (xnode.getEndStructuredDocumentRegion() != null) {
                return null;
            }
            IDOMNode styleNode = null;
            if (!xnode.getNodeName().equalsIgnoreCase(parentTagName)) {
                styleNode = (IDOMNode)xnode.getParentNode();
            }
            if (styleNode != null) {
                tagName = styleNode.getNodeName();
                boolean bl = hasEndTag = styleNode.getEndStructuredDocumentRegion() != null;
            }
        }
        if (!hasEndTag) {
            String proposedText = "</" + tagName;
            String viewerText = viewer.getTextWidget().getText();
            if (viewerText.length() >= documentPosition && viewerText.length() >= 2 && documentPosition >= 2) {
                String last2chars = viewerText.substring(documentPosition - 2, documentPosition);
                if (last2chars.endsWith("</")) {
                    proposedText = tagName;
                } else if (last2chars.endsWith("<")) {
                    proposedText = "/" + tagName;
                }
            }
            p = new CustomCompletionProposal(String.valueOf(proposedText) + ">", documentPosition, 0, proposedText.length() + 1, XMLEditorPluginImageHelper.getInstance().getImage(imagePath), NLS.bind((String)XMLUIMessages.End_with_, (Object[])new Object[]{proposedText}), null, null, 1400);
        }
        return p;
    }

    private static String getMetaScriptType(Document doc) {
        ArrayList<Node> metas = new ArrayList<Node>();
        Node html = null;
        Node head = null;
        Node child = null;
        child = doc.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equalsIgnoreCase(META)) {
                    metas.add(child);
                } else if (child.getNodeName().equalsIgnoreCase(HTML)) {
                    html = child;
                }
            }
            child = child.getNextSibling();
        }
        if (html != null) {
            child = html.getFirstChild();
            while (child != null && head == null) {
                if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase(HEAD)) {
                    head = child;
                }
                child = child.getNextSibling();
            }
        }
        if (head != null) {
            head.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase(META)) {
                    metas.add(child);
                }
                child = child.getNextSibling();
            }
        }
        return XMLContentAssistUtilities.getMetaScriptType(metas);
    }

    private static String getMetaScriptType(List metaNodeList) {
        Node meta = null;
        NamedNodeMap attributes = null;
        boolean httpEquiv = false;
        String contentScriptType = null;
        int i = metaNodeList.size() - 1;
        while (i >= 0) {
            meta = (Node)metaNodeList.get(i);
            attributes = meta.getAttributes();
            httpEquiv = false;
            contentScriptType = null;
            int j = 0;
            while (j < attributes.getLength()) {
                if (attributes.item(j).getNodeName().equalsIgnoreCase(HTTP_EQUIV)) {
                    httpEquiv = attributes.item(j).getNodeValue().equalsIgnoreCase(CONTENT_SCRIPT_TYPE);
                } else if (attributes.item(j).getNodeName().equalsIgnoreCase(CONTENT)) {
                    contentScriptType = attributes.item(j).getNodeValue();
                }
                ++j;
            }
            if (httpEquiv && contentScriptType != null) {
                return contentScriptType;
            }
            --i;
        }
        return null;
    }

    public static String getScriptLanguage(Node scriptNode) {
        Node attr = null;
        boolean specified = false;
        if (scriptNode == null || scriptNode.getAttributes() == null) {
            return null;
        }
        attr = scriptNode.getAttributes().getNamedItem("type");
        if (attr != null) {
            specified = true;
            String type = attr.getNodeValue();
            return XMLContentAssistUtilities.lookupScriptType(type);
        }
        attr = scriptNode.getAttributes().getNamedItem("language");
        if (attr != null) {
            specified = true;
            String language = attr.getNodeValue();
            return XMLContentAssistUtilities.lookupScriptLanguage(language);
        }
        String type = null;
        if (!specified) {
            type = XMLContentAssistUtilities.getMetaScriptType(scriptNode.getOwnerDocument());
        }
        if (type != null) {
            specified = true;
            return XMLContentAssistUtilities.lookupScriptType(type);
        }
        if (!specified) {
            return "javascript";
        }
        return null;
    }

    public static boolean isJSPCloseDelimiter(IStructuredDocumentRegion fn) {
        if (fn == null) {
            return false;
        }
        return XMLContentAssistUtilities.isJSPCloseDelimiter(fn.getType());
    }

    public static boolean isJSPCloseDelimiter(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("JSP_CLOSE") || type.equals("XML_TAG_CLOSE");
    }

    public static boolean isJSPDelimiter(IStructuredDocumentRegion fn) {
        boolean isDelimiter = false;
        String type = fn.getType();
        if (type != null) {
            isDelimiter = XMLContentAssistUtilities.isJSPDelimiter(type);
        }
        return isDelimiter;
    }

    public static boolean isJSPDelimiter(String type) {
        if (type == null) {
            return false;
        }
        return XMLContentAssistUtilities.isJSPOpenDelimiter(type) || XMLContentAssistUtilities.isJSPCloseDelimiter(type);
    }

    public static boolean isJSPOpenDelimiter(IStructuredDocumentRegion fn) {
        if (fn == null) {
            return false;
        }
        return XMLContentAssistUtilities.isJSPOpenDelimiter(fn.getType());
    }

    public static boolean isJSPOpenDelimiter(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("JSP_SCRIPTLET_OPEN") || type.equals("JSP_DECLARATION_OPEN") || type.equals("JSP_EXPRESSION_OPEN");
    }

    public static boolean isXMLJSPDelimiter(IStructuredDocumentRegion fn) {
        boolean isDelimiter = false;
        if (fn != null && fn instanceof ITextRegionContainer) {
            ITextRegion[] regions = fn.getRegions().toArray();
            ITextRegion temp = null;
            String regionText = "";
            int i = 0;
            while (i < regions.length) {
                temp = regions[i];
                if (temp.getType() == "XML_TAG_NAME" && ((regionText = fn.getText(temp)).equalsIgnoreCase("jsp:scriptlet") || regionText.equalsIgnoreCase("jsp:expression") || regionText.equalsIgnoreCase("jsp:declaration"))) {
                    isDelimiter = true;
                }
                ++i;
            }
        }
        return isDelimiter;
    }

    public static String lookupScriptLanguage(String language) {
        int i = 0;
        while (i < ScriptLanguageKeys.JAVASCRIPT_LANGUAGE_KEYS.length) {
            if (ScriptLanguageKeys.JAVASCRIPT_LANGUAGE_KEYS[i].equalsIgnoreCase(language)) {
                return "javascript";
            }
            ++i;
        }
        i = 0;
        while (i < ScriptLanguageKeys.JAVA_LANGUAGE_KEYS.length) {
            if (ScriptLanguageKeys.JAVA_LANGUAGE_KEYS[i].equalsIgnoreCase(language)) {
                return "java";
            }
            ++i;
        }
        return language;
    }

    public static String lookupScriptType(String type) {
        int i = 0;
        while (i < ScriptLanguageKeys.JAVASCRIPT_MIME_TYPE_KEYS.length) {
            if (ScriptLanguageKeys.JAVASCRIPT_MIME_TYPE_KEYS[i].equalsIgnoreCase(type)) {
                return "javascript";
            }
            ++i;
        }
        return type;
    }

    private class DOMJSPRegionContextsPrivateCopy {
        private static final String JSP_CLOSE = "JSP_CLOSE";
        private static final String JSP_DECLARATION_OPEN = "JSP_DECLARATION_OPEN";
        private static final String JSP_SCRIPTLET_OPEN = "JSP_SCRIPTLET_OPEN";
        private static final String JSP_EXPRESSION_OPEN = "JSP_EXPRESSION_OPEN";

        private DOMJSPRegionContextsPrivateCopy() {
        }
    }
}

