/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.core.analysis;

import java.util.Objects;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.scripting.core.analysis.ScriptedAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class AnalysisScriptingModule {
    @WrapToScript
    public @Nullable IAnalysisModule getTraceAnalysis(ITmfTrace trace, String analysisName) {
        for (ITmfTrace childTrace : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace)) {
            for (IAnalysisModule module : childTrace.getAnalysisModules()) {
                if (!module.getName().equals(analysisName) && !module.getId().equals(analysisName)) continue;
                return module;
            }
        }
        return null;
    }

    @WrapToScript
    public ScriptedAnalysis createScriptedAnalysis(@Nullable ITmfTrace trace, String analysisName) {
        return new ScriptedAnalysis(Objects.requireNonNull(trace, "Trace should not be null"), analysisName);
    }
}

