/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.util.HashMap;
import java.util.Map;
import org.python.icu.impl.SimplePatternFormatter;
import org.python.icu.text.DecimalFormat;
import org.python.icu.text.NumberFormat;
import org.python.icu.text.PluralRules;

class QuantityFormatter {
    private static final Map<String, Integer> INDEX_MAP = new HashMap<String, Integer>();
    private static final int MAX_INDEX;
    private final SimplePatternFormatter[] templates;

    private QuantityFormatter(SimplePatternFormatter[] templates) {
        this.templates = templates;
    }

    public String format(double quantity, NumberFormat numberFormat, PluralRules pluralRules) {
        String formatStr = numberFormat.format(quantity);
        String variant = this.computeVariant(quantity, numberFormat, pluralRules);
        return this.getByVariant(variant).format(formatStr);
    }

    public SimplePatternFormatter getByVariant(String variant) {
        Integer idxObj = INDEX_MAP.get(variant);
        SimplePatternFormatter template = this.templates[idxObj == null ? 0 : idxObj];
        return template == null ? this.templates[0] : template;
    }

    private String computeVariant(double quantity, NumberFormat numberFormat, PluralRules pluralRules) {
        if (numberFormat instanceof DecimalFormat) {
            return pluralRules.select(((DecimalFormat)numberFormat).getFixedDecimal(quantity));
        }
        return pluralRules.select(quantity);
    }

    static {
        int idx = 0;
        INDEX_MAP.put("other", idx++);
        INDEX_MAP.put("zero", idx++);
        INDEX_MAP.put("one", idx++);
        INDEX_MAP.put("two", idx++);
        INDEX_MAP.put("few", idx++);
        INDEX_MAP.put("many", idx++);
        MAX_INDEX = idx;
    }

    static class Builder {
        private SimplePatternFormatter[] templates;

        Builder() {
        }

        public Builder add(String variant, String template) {
            this.ensureCapacity();
            Integer idx = (Integer)INDEX_MAP.get(variant);
            if (idx == null) {
                throw new IllegalArgumentException(variant);
            }
            SimplePatternFormatter newT = SimplePatternFormatter.compile(template);
            if (newT.getPlaceholderCount() > 1) {
                throw new IllegalArgumentException("Extra placeholders: " + template);
            }
            this.templates[idx.intValue()] = newT;
            return this;
        }

        public QuantityFormatter build() {
            if (this.templates == null || this.templates[0] == null) {
                throw new IllegalStateException("At least other variant must be set.");
            }
            QuantityFormatter result = new QuantityFormatter(this.templates);
            this.templates = null;
            return result;
        }

        public Builder reset() {
            this.templates = null;
            return this;
        }

        private void ensureCapacity() {
            if (this.templates == null) {
                this.templates = new SimplePatternFormatter[MAX_INDEX];
            }
        }
    }
}

